/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportEthernetConfigPanel;
import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.AirportInfoTextField;
import airport.AirportModemConfigPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;

public class AirportNetworkPanel
extends AirportInfoPanel
implements ItemListener {
    private AirportInfoRadioButton modemButton = new AirportInfoRadioButton("Connect to network through modem");
    private AirportInfoRadioButton ethernetButton;
    private AirportInfoTextField primaryDNSField;
    private AirportInfoTextField secondaryDNSField;
    private AirportInfoTextField domainNameField;
    private AirportInfoPanel ethernetConfigPanel;
    private AirportInfoPanel modemConfigPanel;
    private AirportInfoPanel dnsPanel;
    private ButtonGroup modemEthernetButtonGroup;

    public AirportNetworkPanel(AirportInfo theInfo) {
        this.modemButton.addInfoRecord(theInfo.get("waIn"), "00000004");
        this.modemButton.addInfoRecord(theInfo.get("waCV"), "00000900");
        this.ethernetButton = new AirportInfoRadioButton("Connect to network through Ethernet port");
        this.ethernetButton.addInfoRecord(theInfo.get("waIn"), "00000010");
        this.modemEthernetButtonGroup = new ButtonGroup();
        this.modemEthernetButtonGroup.add(this.modemButton);
        this.modemEthernetButtonGroup.add(this.ethernetButton);
        this.primaryDNSField = new AirportInfoTextField(theInfo.get("waD1"));
        this.secondaryDNSField = new AirportInfoTextField(theInfo.get("waD2"));
        this.domainNameField = new AirportInfoTextField(theInfo.get("waDN"));
        this.ethernetConfigPanel = new AirportEthernetConfigPanel(theInfo);
        this.modemConfigPanel = new AirportModemConfigPanel(theInfo);
        this.setUpDisplay();
    }

    public void setUpDisplay() {
        Insets theMargin;
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        this.dnsPanel = new AirportInfoPanel();
        this.dnsPanel.setLayout(theLayout);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = 1;
        JLabel label = new JLabel("Primary DNS server IP address");
        theLayout.setConstraints(label, c);
        this.dnsPanel.add(label);
        c.anchor = 17;
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.primaryDNSField, c);
        this.dnsPanel.add(this.primaryDNSField);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = 2;
        label = new JLabel("Secondary DNS server IP address");
        theLayout.setConstraints(label, c);
        this.dnsPanel.add(label);
        c.anchor = 17;
        c.gridx = 2;
        c.gridy = 2;
        theLayout.setConstraints(this.secondaryDNSField, c);
        this.dnsPanel.add(this.secondaryDNSField);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = 3;
        label = new JLabel("Domain name");
        theLayout.setConstraints(label, c);
        this.dnsPanel.add(label);
        c.anchor = 17;
        c.gridx = 2;
        c.gridy = 3;
        theLayout.setConstraints(this.domainNameField, c);
        this.dnsPanel.add(this.domainNameField);
        this.setLayout(theLayout);
        c.anchor = 10;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.ethernetButton, c);
        this.add(this.ethernetButton);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.modemButton, c);
        this.add(this.modemButton);
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.ethernetConfigPanel, c);
        this.add(this.ethernetConfigPanel);
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.modemConfigPanel, c);
        this.add(this.modemConfigPanel);
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 3;
        theLayout.setConstraints(this.dnsPanel, c);
        this.add(this.dnsPanel);
        this.modemButton.addItemListener(this.modemConfigPanel);
        this.modemButton.addItemListener(this);
        this.modemConfigPanel.setEnabled(this.modemButton.isSelected());
        this.modemConfigPanel.setVisible(this.modemButton.isSelected());
        this.ethernetButton.addItemListener(this.ethernetConfigPanel);
        this.ethernetButton.addItemListener(this);
        this.ethernetConfigPanel.setEnabled(this.ethernetButton.isSelected());
        this.ethernetConfigPanel.setVisible(this.ethernetButton.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        this.modemConfigPanel.setVisible(this.modemButton.isSelected());
        this.ethernetConfigPanel.setVisible(this.ethernetButton.isSelected());
    }
}

