/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AirportPortMappingTable
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private Vector addressVector;
    private JTable table;
    private AbstractTableModel tableModel;

    public AirportPortMappingTable(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        int numMacAddresses = 0;
        Vector<AirportInfoRecord> publicPortVector = new Vector<AirportInfoRecord>();
        Vector<AirportInfoRecord> privateIPVector = new Vector<AirportInfoRecord>();
        Vector<AirportInfoRecord> privatePortVector = new Vector<AirportInfoRecord>();
        int i = 0;
        while (i < this.addressVector.size()) {
            block11: {
                try {
                    if (((String[])this.addressVector.elementAt(i))[0].equals("")) break block11;
                    AirportInfoRecord publicPortRecord = new AirportInfoRecord("temp", "temp", 4, 0, 2);
                    publicPortRecord.setBytesFromString(((String[])this.addressVector.elementAt(i))[0]);
                    publicPortVector.add(publicPortRecord);
                    ++numMacAddresses;
                }
                catch (ValueFormatException e) {
                    this.table.editCellAt(i, 0);
                    throw e;
                }
                try {
                    AirportInfoRecord privateIPRecord = new AirportInfoRecord("temp", "temp", 1, 0, 4);
                    privateIPRecord.setBytesFromString(((String[])this.addressVector.elementAt(i))[1]);
                    privateIPVector.add(privateIPRecord);
                }
                catch (ValueFormatException e) {
                    this.table.editCellAt(i, 1);
                    throw e;
                }
                try {
                    AirportInfoRecord privatePortRecord = new AirportInfoRecord("temp", "temp", 4, 0, 2);
                    privatePortRecord.setBytesFromString(((String[])this.addressVector.elementAt(i))[2]);
                    privatePortVector.add(privatePortRecord);
                }
                catch (ValueFormatException e) {
                    this.table.editCellAt(i, 2);
                    throw e;
                }
            }
            ++i;
        }
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] zeroBytes = new byte[4];
            outStream.write(zeroBytes);
            AirportInfoRecord sizeRecord = new AirportInfoRecord("temp", "temp", 4, 0, 4);
            sizeRecord.setBytesFromString(Integer.toString(numMacAddresses));
            outStream.write(sizeRecord.value);
            zeroBytes = new byte[8];
            outStream.write(zeroBytes);
            int i2 = 0;
            while (i2 < numMacAddresses) {
                outStream.write(((AirportInfoRecord)privateIPVector.elementAt((int)i2)).value);
                outStream.write(((AirportInfoRecord)privatePortVector.elementAt((int)i2)).value);
                outStream.write(((AirportInfoRecord)publicPortVector.elementAt((int)i2)).value);
                ++i2;
            }
            AirportInfoRecord accessControlRecord = this.airportInfo.get("pmTa");
            accessControlRecord.setValue(outStream.toByteArray());
        }
        catch (IOException iOException) {}
    }

    public void refreshDisplay() {
        AirportInfoRecord portMapRecord = this.airportInfo.get("pmTa");
        byte[] portMapBytes = portMapRecord.getValue();
        DataInputStream inStream = new DataInputStream(new ByteArrayInputStream(portMapBytes));
        try {
            inStream.skip(4L);
            int numPortMaps = inStream.readInt();
            inStream.skip(8L);
            this.addressVector = new Vector();
            int i = 0;
            while (i < numPortMaps) {
                byte[] addressBytes = new byte[4];
                inStream.read(addressBytes);
                AirportInfoRecord privateIPRecord = new AirportInfoRecord("temp", "temp", 1, 0, 4, addressBytes);
                byte[] privatePortBytes = new byte[2];
                inStream.read(privatePortBytes);
                AirportInfoRecord privatePortRecord = new AirportInfoRecord("temp", "temp", 4, 0, 2, privatePortBytes);
                byte[] publicPortBytes = new byte[2];
                inStream.read(publicPortBytes);
                AirportInfoRecord publicPortRecord = new AirportInfoRecord("temp", "temp", 4, 0, 2, publicPortBytes);
                String[] addressEntry = new String[]{publicPortRecord.toString(), privateIPRecord.toString(), privatePortRecord.toString()};
                this.addressVector.insertElementAt(addressEntry, this.addressVector.size());
                ++i;
            }
            this.removeAll();
            this.tableModel = new PortMappingTableModel();
            this.table = new JTable(this.tableModel);
            this.table.setCellSelectionEnabled(true);
            this.table.setPreferredScrollableViewportSize(new Dimension(350, 200));
            JScrollPane scrollPane = new JScrollPane(this.table);
            this.add(scrollPane);
        }
        catch (IOException iOException) {}
    }

    private class PortMappingTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return 20;
        }

        public boolean isCellEditable(int row, int col) {
            return row <= AirportPortMappingTable.this.addressVector.size();
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Public port number";
                }
                case 1: {
                    return "Private IP address";
                }
                case 2: {
                    return "Private port number";
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            if (row < AirportPortMappingTable.this.addressVector.size()) {
                return ((String[])AirportPortMappingTable.this.addressVector.elementAt(row))[col];
            }
            return "";
        }

        public void setValueAt(Object newValue, int row, int col) {
            if (newValue instanceof String) {
                if (row < AirportPortMappingTable.this.addressVector.size()) {
                    String[] addressEntry = (String[])AirportPortMappingTable.this.addressVector.elementAt(row);
                    addressEntry[col] = (String)newValue;
                } else {
                    String[] addressEntry = new String[]{"", "", ""};
                    addressEntry[col] = (String)newValue;
                    AirportPortMappingTable.this.addressVector.insertElementAt(addressEntry, AirportPortMappingTable.this.addressVector.size());
                }
            }
        }

        PortMappingTableModel() {
        }
    }
}

