/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.ValueFormatException;
import byteblock.ByteBlock;
import byteblock.ByteBlockRectangularWindow;
import byteblock.ByteBlockWindow;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class AirportInfoRecord {
    public static final int CHAR_STRING = 0;
    public static final int IP_ADDRESS = 1;
    public static final int BYTE_STRING = 2;
    public static final int PHONE_NUMBER = 3;
    public static final int UNSIGNED_INTEGER = 4;
    public static final int BYTE = 5;
    public static final int LITTLE_ENDIAN_UNSIGNED_INTEGER = 6;
    public int dataType;
    public ByteBlockWindow byteBlockWindow;

    public AirportInfoRecord(int n, int n2, int n3, int n4, ByteBlock byteBlock) {
        this.dataType = n4;
        this.byteBlockWindow = new ByteBlockRectangularWindow(n, n2, n3, byteBlock);
    }

    public AirportInfoRecord(int n, ByteBlockWindow byteBlockWindow) {
        this.dataType = n;
        this.byteBlockWindow = byteBlockWindow;
    }

    public void clearWindow() {
        this.byteBlockWindow.clearBytes();
    }

    public String toString() {
        String string = new String();
        switch (this.dataType) {
            case 4: {
                try {
                    byte[] byArray = this.byteBlockWindow.getBytes();
                    string = this.convertToUnsignedInteger(byArray);
                }
                catch (NumberFormatException numberFormatException) {
                    string = this.byteBlockWindow.toHexString();
                }
                break;
            }
            case 6: {
                try {
                    byte[] byArray = this.byteBlockWindow.getBytes();
                    byArray = this.reverseBytes(byArray);
                    string = this.convertToUnsignedInteger(byArray);
                }
                catch (NumberFormatException numberFormatException) {
                    string = this.byteBlockWindow.toHexString();
                }
                break;
            }
            case 0: {
                string = new String(this.byteBlockWindow.getBytes());
                int n = string.indexOf(0);
                if (n < 0) break;
                string = string.substring(0, n);
                break;
            }
            case 3: {
                string = this.convertToPhoneNumber(this.byteBlockWindow.getBytes());
                break;
            }
            case 1: {
                string = this.convertToIPAddress(this.byteBlockWindow.getBytes());
                break;
            }
            default: {
                string = this.byteBlockWindow.toHexString();
            }
        }
        return string;
    }

    private String convertToUnsignedInteger(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        return bigInteger.toString();
    }

    private String convertToIPAddress(byte[] byArray) {
        int n;
        String string = new String();
        int n2 = 0;
        while (n2 < byArray.length - 1) {
            n = byArray[n2];
            if (n < 0) {
                n += 256;
            }
            string = String.valueOf(string) + n + ".";
            ++n2;
        }
        n = byArray[byArray.length - 1];
        if (n < 0) {
            n += 256;
        }
        string = String.valueOf(string) + n;
        return string;
    }

    public static char decodePhoneDigit(byte by) {
        int n = by == 10 ? 42 : (by == 11 ? 35 : (by == 12 ? 44 : (by == 13 ? 32 : (by == 14 ? 45 : (by == 15 ? 46 : (int)Byte.toString(by).charAt(0))))));
        return (char)n;
    }

    private String convertToPhoneNumber(byte[] byArray) {
        String string = new String();
        int n = 0;
        while (n < byArray.length) {
            int n2 = (byArray[n] & 0xF0) >>> 4;
            int n3 = byArray[n] & 0xF;
            string = n2 == 14 ? String.valueOf(string) + "-" : (n2 == 13 ? String.valueOf(string) + " " : (n2 == 12 ? String.valueOf(string) + "," : String.valueOf(string) + n2));
            string = n3 == 14 ? String.valueOf(string) + "-" : (n3 == 13 ? String.valueOf(string) + " " : (n3 == 12 ? String.valueOf(string) + "," : String.valueOf(string) + n3));
            ++n;
        }
        return string;
    }

    public void setBytesFromString(String string) throws ValueFormatException {
        byte[] byArray;
        int n = this.byteBlockWindow.getSize();
        switch (this.dataType) {
            case 4: {
                byArray = this.convertFromUnsignedInteger(string);
                break;
            }
            case 6: {
                byArray = this.convertFromUnsignedInteger(string);
                byArray = this.reverseBytes(byArray);
                break;
            }
            case 0: {
                string = String.valueOf(string) + "\u0000";
                if (string.length() > n) {
                    throw new ValueFormatException("Maximum " + (n - 1) + " characters.");
                }
                byArray = string.getBytes();
                break;
            }
            case 3: {
                byArray = this.convertFromPhoneNumber(string);
                break;
            }
            case 1: {
                byArray = this.convertFromIPv4Address(string);
                break;
            }
            default: {
                byArray = this.convertFromHexString(string);
            }
        }
        this.byteBlockWindow.writeBytes(byArray);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] convertFromIPv4Address(String var1_1) throws ValueFormatException {
        var2_2 = this.byteBlockWindow.getSize();
        var3_3 = new byte[var2_2];
        var4_4 = 0;
        var6_5 = new StringTokenizer(var1_1, ".");
        if (var6_5.countTokens() == var2_2) ** GOTO lbl19
        if (var2_2 == 4) {
            throw new ValueFormatException("Bad IP address: must be of form a.b.c.d, with a,b,c and d between 0 and 255.");
        }
        throw new ValueFormatException("Bad dotted address supplied: should have " + var2_2 + " components.");
lbl-1000:
        // 1 sources

        {
            try {
                var7_7 = var6_5.nextToken();
                var5_6 = Integer.parseInt(var7_7);
                if (var5_6 < 0 || var5_6 > 255) {
                    throw new ValueFormatException("Bad IP address: must be of form a.b.c.d, with a,b,c and d between 0 and 255.");
                }
                var3_3[var4_4] = (byte)var5_6;
                ++var4_4;
                continue;
            }
            catch (NumberFormatException v0) {
                throw new ValueFormatException("Bad IP address: must be of form a.b.c.d, with a,b,c and d between 0 and 255.");
            }
lbl19:
            // 2 sources

            ** while (var6_5.hasMoreTokens())
        }
lbl20:
        // 1 sources

        return var3_3;
    }

    public static byte encodePhoneDigit(char c) throws NumberFormatException {
        int n = c == '*' ? 10 : (c == '#' ? 11 : (c == ',' ? 12 : (c == ' ' || c == '(' || c == ')' ? 13 : (c == '-' ? 14 : (c == '.' ? 15 : (int)((byte)Character.digit(c, 10)))))));
        return (byte)n;
    }

    private byte[] convertFromPhoneNumber(String string) throws ValueFormatException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[(cArray.length + 1) / 2];
        int n = 0;
        while (n < cArray.length) {
            int n2;
            if (cArray[n] == '-') {
                n2 = 14;
            } else if (cArray[n] == ' ' || cArray[n] == '(' || cArray[n] == ')') {
                n2 = 13;
            } else if (cArray[n] == ',') {
                n2 = 12;
            } else {
                try {
                    n2 = (byte)Integer.parseInt(string.substring(n, n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ValueFormatException("Invalid phone number");
                }
            }
            if (2 * (n / 2) == n) {
                n2 = (byte)(n2 << 4);
            }
            int n3 = (n + 1) / 2;
            byArray[n3] = (byte)(byArray[n3] & n2);
            ++n;
        }
        return byArray;
    }

    private byte[] convertFromUnsignedInteger(String string) throws ValueFormatException {
        int n = this.byteBlockWindow.getSize();
        byte[] byArray = new byte[n];
        try {
            int n2 = 0;
            long l = 1L;
            int n3 = 0;
            while (n3 < n) {
                l *= 256L;
                ++n3;
            }
            long l2 = Long.parseLong(string);
            if (l2 < (long)n2 || l2 > --l) {
                throw new ValueFormatException("Value must be between " + n2 + " and " + l + ".");
            }
            int n4 = 0;
            while (n4 < n) {
                byArray[n - n4 - 1] = (byte)(l2 % 256L);
                l2 /= 256L;
                ++n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValueFormatException("Bad number format.");
        }
        return byArray;
    }

    private byte[] convertFromHexString(String string) throws ValueFormatException {
        int n;
        int n2 = this.byteBlockWindow.getSize();
        byte[] byArray = new byte[n2];
        string.trim();
        while ((n = string.indexOf(32)) != -1) {
            string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
        }
        if (2 * (string.length() / 2) != string.length()) {
            throw new ValueFormatException("Must have an even number of hexadecimal digits.");
        }
        if (string.length() / 2 > n2) {
            throw new ValueFormatException("Too many hexadecimal digits (maximum " + n2 + " bytes = " + 2 * n2 + " hex digits).");
        }
        int n3 = 0;
        while (n3 < string.length() / 2) {
            String string2 = string.substring(2 * n3, 2 * n3 + 2);
            try {
                int n4 = Integer.parseInt(string2, 16);
                byArray[n3] = (byte)n4;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValueFormatException("Entries must be hexadecimal digits (0 through 9 and a through f or A through F) or spaces.");
            }
            ++n3;
        }
        return byArray;
    }

    private byte[] reverseBytes(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n - n2 - 1];
            ++n2;
        }
        return byArray2;
    }
}

