/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoLabelledScaledValueField;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.AirportPPPoELoginInfoDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;

public class AirportPPPoEConfigPanel
extends AirportInfoPanel
implements ActionListener {
    private JButton loginButton;
    private ButtonGroup connectionGroup;
    private AirportInfoRadioButton pppoeAlwaysStayConnectedButton;
    private AirportInfoRadioButton pppoeAutomaticConnectButton;
    private AirportInfoRadioButton pppoeManualConnectButton;
    private AirportInfoLabelledScaledValueField pppoeDisconnectTimeoutField;
    private AirportInfo theInfo;
    private AirportInfoPanel pppoeDisconnectTimeoutPanel;

    public AirportPPPoEConfigPanel(AirportInfo airportInfo) {
        this.theInfo = airportInfo;
        this.pppoeAlwaysStayConnectedButton = new AirportInfoRadioButton("Always stay connected", airportInfo.get("PPPoE stay connected"), "40");
        this.pppoeAutomaticConnectButton = new AirportInfoRadioButton("Connect automatically", airportInfo.get("PPPoE auto connect"), "04");
        this.pppoeManualConnectButton = new AirportInfoRadioButton("Don't connect automatically", airportInfo.get("PPPoE auto connect"), "06");
        this.connectionGroup = new ButtonGroup();
        this.connectionGroup.add(this.pppoeAlwaysStayConnectedButton);
        this.connectionGroup.add(this.pppoeAutomaticConnectButton);
        this.connectionGroup.add(this.pppoeManualConnectButton);
        this.pppoeDisconnectTimeoutField = new AirportInfoLabelledScaledValueField("PPPoE idle timeout (minutes; 0 = never)", airportInfo.get("PPPoE idle timeout"), 6);
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.loginButton = new JButton("Username/Password");
        this.loginButton.setActionCommand("show login panel");
        this.loginButton.addActionListener(this);
        this.pppoeDisconnectTimeoutPanel = new AirportInfoPanel();
        this.pppoeDisconnectTimeoutPanel.add(this.pppoeDisconnectTimeoutField);
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.pppoeAlwaysStayConnectedButton, gridBagConstraints);
        this.add(this.pppoeAlwaysStayConnectedButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.pppoeAutomaticConnectButton, gridBagConstraints);
        this.add(this.pppoeAutomaticConnectButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.pppoeManualConnectButton, gridBagConstraints);
        this.add(this.pppoeManualConnectButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.loginButton, gridBagConstraints);
        this.add(this.loginButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.pppoeDisconnectTimeoutPanel, gridBagConstraints);
        this.add(this.pppoeDisconnectTimeoutPanel);
        this.pppoeAutomaticConnectButton.addItemListener(this.pppoeDisconnectTimeoutPanel);
        this.pppoeManualConnectButton.addItemListener(this.pppoeDisconnectTimeoutPanel);
        this.pppoeDisconnectTimeoutPanel.setEnabled(this.pppoeAutomaticConnectButton.isSelected() || this.pppoeManualConnectButton.isSelected());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.pppoeDisconnectTimeoutPanel.setEnabled(this.pppoeAutomaticConnectButton.isSelected() || this.pppoeManualConnectButton.isSelected());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("show login panel")) {
            Container container = this;
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            Frame frame = (Frame)container;
            AirportPPPoELoginInfoDialog airportPPPoELoginInfoDialog = new AirportPPPoELoginInfoDialog(frame, "PPPoE Login Information", true, this.theInfo);
            airportPPPoELoginInfoDialog.pack();
            Dimension dimension = airportPPPoELoginInfoDialog.getSize();
            dimension.height += 20;
            dimension.width += 20;
            ((Component)airportPPPoELoginInfoDialog).setSize(dimension);
            airportPPPoELoginInfoDialog.show();
        }
    }
}

