/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoComboBox;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AirportPhoneNumberPanel
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private JTextField modemInitField;
    private JTextField primaryPhoneField;
    private JTextField secondaryPhoneField;
    private AirportInfoComboBox countryCodeBox;
    private static final int countryCodePrefixCount = 5;
    private static final int countFieldCount = 3;

    public AirportPhoneNumberPanel(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.countryCodeBox = new AirportInfoComboBox("Country", airportInfo.get("Phone country code"));
        this.countryCodeBox.addItemAndValue("North America", "3232");
        this.countryCodeBox.addItemAndValue("Guam (same as North America)", "3232");
        this.countryCodeBox.addItemAndValue("Hong Kong (same as North America)", "3232");
        this.countryCodeBox.addItemAndValue("India (same as North America)", "3232");
        this.countryCodeBox.addItemAndValue("Latin America (same as North America)", "3232");
        this.countryCodeBox.addItemAndValue("Phillipines (same as North America)", "3232");
        this.countryCodeBox.addItemAndValue("Thailand (same as North America)", "3232");
        this.countryCodeBox.addItemAndValue("Singapore", "3437");
        this.countryCodeBox.addItemAndValue("China (same as Singapore)", "3437");
        this.countryCodeBox.addItemAndValue("Czech Republic (same as Singapore)", "3437");
        this.countryCodeBox.addItemAndValue("Slovak Republic (same as Singapore)", "3437");
        this.countryCodeBox.addItemAndValue("Korea (same as Singapore)", "3437");
        this.countryCodeBox.addItemAndValue("Malaysia (same as Singapore)", "3437");
        this.countryCodeBox.addItemAndValue("Poland (same as Singapore)", "3437");
        this.countryCodeBox.addItemAndValue("Taiwan (same as Singapore)", "3437");
        this.countryCodeBox.addItemAndValue("Switzerland", "3135");
        this.countryCodeBox.addItemAndValue("Portugal (same as Switzerland)", "3135");
        this.countryCodeBox.addItemAndValue("Spain (same as Switzerland)", "3135");
        this.countryCodeBox.addItemAndValue("Finland", "3034");
        this.countryCodeBox.addItemAndValue("Germany (same as Finland)", "3034");
        this.countryCodeBox.addItemAndValue("Iceland (same as Finland)", "3034");
        this.countryCodeBox.addItemAndValue("Netherlands (same as Finland)", "3034");
        this.countryCodeBox.addItemAndValue("Australia", "3430");
        this.countryCodeBox.addItemAndValue("South Africa (same as Australia)", "3430");
        this.countryCodeBox.addItemAndValue("United Kingdom", "3136");
        this.countryCodeBox.addItemAndValue("Belgium (same as United Kingdom)", "3136");
        this.countryCodeBox.addItemAndValue("Denmark (same as United Kingdom)", "3136");
        this.countryCodeBox.addItemAndValue("Greece (same as United Kingdom)", "3136");
        this.countryCodeBox.addItemAndValue("Ireland (same as United Kingdom)", "3136");
        this.countryCodeBox.addItemAndValue("Norway (same as United Kingdom)", "3136");
        this.countryCodeBox.addItemAndValue("New Zealand", "3438");
        this.countryCodeBox.addItemAndValue("France", "3035");
        this.countryCodeBox.addItemAndValue("Japan", "3433");
        this.countryCodeBox.addItemAndValue("Austria", "3031");
        this.countryCodeBox.addItemAndValue("Italy", "3038");
        this.countryCodeBox.addItemAndValue("Sweden", "3134");
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets insets;
        this.modemInitField = new JTextField(10);
        this.primaryPhoneField = new JTextField(10);
        this.secondaryPhoneField = new JTextField(10);
        JLabel jLabel = new JLabel("Modem init string");
        JLabel jLabel2 = new JLabel("Phone number");
        JLabel jLabel3 = new JLabel("Secondary phone number");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.add(jLabel2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.primaryPhoneField, gridBagConstraints);
        this.add(this.primaryPhoneField);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.modemInitField, gridBagConstraints);
        this.add(this.modemInitField);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.countryCodeBox, gridBagConstraints);
        this.add(this.countryCodeBox);
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Modem init/phone number block");
        airportInfoRecord.clearWindow();
        String string = this.modemInitField.getText();
        string = "   *NC22" + string;
        String string2 = new String();
        string2 = String.valueOf(string2) + this.primaryPhoneField.getText();
        string2 = String.valueOf(string2) + this.secondaryPhoneField.getText();
        byte[] byArray = this.convertFromPhoneNumber(string2);
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        int n = 0;
        while (n < byArray2.length) {
            byArray3[n] = byArray2[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray3[n2 + byArray2.length] = byArray[n2];
            ++n2;
        }
        airportInfoRecord.byteBlockWindow.writeBytes(byArray3);
        int n3 = this.modemInitField.getText().length();
        AirportInfoRecord airportInfoRecord2 = this.airportInfo.get("Modem init string length");
        String string3 = new String();
        string3 = String.valueOf(string3) + (n3 += 5);
        airportInfoRecord2.setBytesFromString(string3);
        int n4 = this.primaryPhoneField.getText().length();
        AirportInfoRecord airportInfoRecord3 = this.airportInfo.get("Primary phone number length");
        String string4 = new String();
        string4 = String.valueOf(string4) + n4;
        airportInfoRecord3.setBytesFromString(string4);
        int n5 = this.secondaryPhoneField.getText().length();
        AirportInfoRecord airportInfoRecord4 = this.airportInfo.get("Secondary phone number length");
        String string5 = new String();
        string5 = String.valueOf(string5) + n5;
        airportInfoRecord4.setBytesFromString(string5);
        this.countryCodeBox.writeValue();
    }

    public void refreshDisplay() {
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Modem init string length");
        int n = Integer.parseInt(airportInfoRecord.toString());
        AirportInfoRecord airportInfoRecord2 = this.airportInfo.get("Primary phone number length");
        int n2 = Integer.parseInt(airportInfoRecord2.toString());
        AirportInfoRecord airportInfoRecord3 = this.airportInfo.get("Secondary phone number length");
        int n3 = Integer.parseInt(airportInfoRecord3.toString());
        AirportInfoRecord airportInfoRecord4 = this.airportInfo.get("Modem init/phone number block");
        byte[] byArray = airportInfoRecord4.byteBlockWindow.getBytes();
        int n4 = n - 5;
        if (n4 < 0) {
            n4 = 0;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        while (n5 < n4) {
            byArray2[n5] = byArray[n5 + 5 + 3];
            ++n5;
        }
        String string = new String(byArray2);
        this.modemInitField.setText(string);
        int n6 = n4 + 5 + 3;
        int n7 = 2 * n6;
        int n8 = 2 * n6 + n2;
        String string2 = this.convertToPhoneNumber(byArray, n7, n8);
        this.primaryPhoneField.setText(string2);
        n7 = 2 * n6 + n2;
        n8 = 2 * n6 + n2 + n3;
        String string3 = this.convertToPhoneNumber(byArray, n7, n8);
        this.secondaryPhoneField.setText(string3);
    }

    private String convertToPhoneNumber(byte[] byArray, int n, int n2) {
        byte by;
        int n3;
        String string = new String();
        if (2 * (n / 2) != n) {
            n3 = (byte)(byArray[n / 2] & 0xF);
            string = String.valueOf(string) + AirportInfoRecord.decodePhoneDigit((byte)n3);
        }
        n3 = (n + 1) / 2;
        while (n3 < n2 / 2) {
            by = (byte)((byArray[n3] & 0xF0) >>> 4);
            byte by2 = (byte)(byArray[n3] & 0xF);
            string = String.valueOf(string) + AirportInfoRecord.decodePhoneDigit(by);
            string = String.valueOf(string) + AirportInfoRecord.decodePhoneDigit(by2);
            ++n3;
        }
        if (2 * (n2 / 2) != n2) {
            by = (byte)((byArray[n2 / 2] & 0xF0) >>> 4);
            string = String.valueOf(string) + AirportInfoRecord.decodePhoneDigit(by);
        }
        return string;
    }

    private byte[] convertFromPhoneNumber(String string) throws ValueFormatException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[(cArray.length + 1) / 2];
        int n = 0;
        while (n < cArray.length) {
            byte by;
            try {
                by = AirportInfoRecord.encodePhoneDigit(cArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValueFormatException("Invalid phone number");
            }
            if (2 * (n / 2) == n) {
                by = (byte)(by << 4);
            }
            int n2 = n / 2;
            byArray[n2] = (byte)(byArray[n2] | by);
            ++n;
        }
        return byArray;
    }
}

