/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import byteblock.ByteBlock;
import byteblock.ByteBlockMultiWindow;
import byteblock.ByteBlockRectangularWindow;
import byteblock.ByteBlockWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AirportPortMappingTable
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private Vector addressVector;
    private JTable table;
    private AbstractTableModel tableModel;

    public AirportPortMappingTable(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        String string;
        Object object;
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        ByteBlock byteBlock = this.airportInfo.baseBlock;
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Public port numbers");
        airportInfoRecord.clearWindow();
        airportInfoRecord = this.airportInfo.get("Private IP addresses, first two octets");
        airportInfoRecord.clearWindow();
        airportInfoRecord = this.airportInfo.get("Private IP addresses, last two octets");
        airportInfoRecord.clearWindow();
        airportInfoRecord = this.airportInfo.get("Private port numbers");
        airportInfoRecord.clearWindow();
        int n = 0;
        int n2 = 3522;
        int n3 = 1;
        int n4 = 2;
        int n5 = 4;
        int n6 = 3562;
        int n7 = 1;
        int n8 = 2;
        int n9 = 3602;
        int n10 = 1;
        int n11 = 2;
        int n12 = 1;
        int n13 = 3642;
        int n14 = 1;
        int n15 = 2;
        int n16 = 4;
        int n17 = 0;
        while (n17 < this.addressVector.size()) {
            object = ((String[])this.addressVector.elementAt(n17))[0];
            string = ((String[])this.addressVector.elementAt(n17))[1];
            String string2 = ((String[])this.addressVector.elementAt(n17))[2];
            if (!(((String)object).equals("") && string.equals("") && string2.equals(""))) {
                Object object2;
                try {
                    object2 = new AirportInfoRecord(n2, n3, n4, n5, byteBlock);
                    ((AirportInfoRecord)object2).setBytesFromString((String)object);
                }
                catch (ValueFormatException valueFormatException) {
                    this.table.editCellAt(n17, 0);
                    throw valueFormatException;
                }
                try {
                    object2 = new ByteBlockMultiWindow();
                    ByteBlockRectangularWindow byteBlockRectangularWindow = new ByteBlockRectangularWindow(n6, n7, n8, byteBlock);
                    ((ByteBlockMultiWindow)object2).addWindow(byteBlockRectangularWindow);
                    ByteBlockRectangularWindow byteBlockRectangularWindow2 = new ByteBlockRectangularWindow(n9, n10, n11, byteBlock);
                    ((ByteBlockMultiWindow)object2).addWindow(byteBlockRectangularWindow2);
                    AirportInfoRecord airportInfoRecord2 = new AirportInfoRecord(n12, (ByteBlockWindow)object2);
                    airportInfoRecord2.setBytesFromString(string);
                }
                catch (ValueFormatException valueFormatException) {
                    this.table.editCellAt(n17, 1);
                    throw valueFormatException;
                }
                try {
                    object2 = new AirportInfoRecord(n13, n14, n15, n16, byteBlock);
                    ((AirportInfoRecord)object2).setBytesFromString(string2);
                }
                catch (ValueFormatException valueFormatException) {
                    this.table.editCellAt(n17, 2);
                    throw valueFormatException;
                }
                n2 += 2;
                n6 += 2;
                n9 += 2;
                n13 += 2;
                ++n;
            }
            ++n17;
        }
        object = this.airportInfo.get("Count of port mappings");
        string = new String();
        string = String.valueOf(string) + n;
        ((AirportInfoRecord)object).setBytesFromString(string);
    }

    public void refreshDisplay() {
        Object object;
        ByteBlock byteBlock = this.airportInfo.baseBlock;
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Count of port mappings");
        String string = airportInfoRecord.toString();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Problem with number of Mac addresses");
        }
        this.addressVector = new Vector();
        int n2 = 3522;
        int n3 = 1;
        int n4 = 2;
        int n5 = 4;
        int n6 = 3562;
        int n7 = 1;
        int n8 = 2;
        int n9 = 3602;
        int n10 = 1;
        int n11 = 2;
        int n12 = 1;
        int n13 = 3642;
        int n14 = 1;
        int n15 = 2;
        int n16 = 4;
        int n17 = 0;
        while (n17 < n) {
            object = new AirportInfoRecord(n2, n3, n4, n5, byteBlock);
            ByteBlockMultiWindow byteBlockMultiWindow = new ByteBlockMultiWindow();
            ByteBlockRectangularWindow byteBlockRectangularWindow = new ByteBlockRectangularWindow(n6, n7, n8, byteBlock);
            byteBlockMultiWindow.addWindow(byteBlockRectangularWindow);
            ByteBlockRectangularWindow byteBlockRectangularWindow2 = new ByteBlockRectangularWindow(n9, n10, n11, byteBlock);
            byteBlockMultiWindow.addWindow(byteBlockRectangularWindow2);
            AirportInfoRecord airportInfoRecord2 = new AirportInfoRecord(n12, byteBlockMultiWindow);
            AirportInfoRecord airportInfoRecord3 = new AirportInfoRecord(n13, n14, n15, n16, byteBlock);
            String[] stringArray = new String[]{((AirportInfoRecord)object).toString(), airportInfoRecord2.toString(), airportInfoRecord3.toString()};
            this.addressVector.insertElementAt(stringArray, this.addressVector.size());
            n2 += 2;
            n6 += 2;
            n9 += 2;
            n13 += 2;
            ++n17;
        }
        this.removeAll();
        this.tableModel = new PortMappingTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setCellSelectionEnabled(true);
        this.table.setPreferredScrollableViewportSize(new Dimension(350, 200));
        object = new JScrollPane(this.table);
        this.add((Component)object);
    }

    private class PortMappingTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return 20;
        }

        public boolean isCellEditable(int n, int n2) {
            return n <= AirportPortMappingTable.this.addressVector.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Public port number";
                }
                case 1: {
                    return "Private IP address";
                }
                case 2: {
                    return "Private port number";
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            if (n < AirportPortMappingTable.this.addressVector.size()) {
                return ((String[])AirportPortMappingTable.this.addressVector.elementAt(n))[n2];
            }
            return "";
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof String) {
                if (n < AirportPortMappingTable.this.addressVector.size()) {
                    String[] stringArray = (String[])AirportPortMappingTable.this.addressVector.elementAt(n);
                    stringArray[n2] = (String)object;
                } else {
                    String[] stringArray = new String[]{"", "", ""};
                    stringArray[n2] = (String)object;
                    AirportPortMappingTable.this.addressVector.insertElementAt(stringArray, AirportPortMappingTable.this.addressVector.size());
                }
            }
        }

        PortMappingTableModel() {
        }
    }
}

