/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.util.StringTokenizer;
import snmp.SNMPBadValueException;
import snmp.SNMPOctetString;

public class SNMPIPAddress
extends SNMPOctetString {
    protected byte tag = (byte)64;

    public SNMPIPAddress() {
        this.data = new byte[4];
        int n = 0;
        while (n < 4) {
            this.data[n] = 0;
            ++n;
        }
    }

    public SNMPIPAddress(byte[] byArray) throws SNMPBadValueException {
        if (byArray.length != 4) {
            throw new SNMPBadValueException(" IPAddress: bad BER encoding supplied to set value ");
        }
        this.data = byArray;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof byte[] && ((byte[])object).length == 4) {
            this.data = (byte[])object;
        } else if (object instanceof String) {
            this.data = this.parseIPAddress((String)object);
        } else {
            throw new SNMPBadValueException(" IPAddress: bad data supplied to set value ");
        }
    }

    public String toString() {
        String string = new String();
        if (this.data.length > 0) {
            int n = this.data[0];
            if (n < 0) {
                n += 256;
            }
            string = String.valueOf(string) + n;
            int n2 = 1;
            while (n2 < this.data.length) {
                n = this.data[n2];
                if (n < 0) {
                    n += 256;
                }
                string = String.valueOf(string) + "." + n;
                ++n2;
            }
        }
        return string;
    }

    private byte[] parseIPAddress(String string) throws SNMPBadValueException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                stringTokenizer.nextToken();
            }
            if (n != 4) {
                throw new SNMPBadValueException(" IPAddress: wrong number of components supplied to set value ");
            }
            byte[] byArray = new byte[n];
            stringTokenizer = new StringTokenizer(string, " .");
            int n2 = 0;
            while (n2 < n) {
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                if (n3 < 0 || n3 > 255) {
                    throw new SNMPBadValueException(" IPAddress: invalid component supplied to set value ");
                }
                byArray[n2] = (byte)n3;
                ++n2;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SNMPBadValueException(" IPAddress: invalid component supplied to set value ");
        }
    }
}

