/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPObject;

public class SNMPObjectIdentifier
extends SNMPObject {
    private int[] digits;

    public SNMPObjectIdentifier() {
        this.digits = new int[0];
    }

    public SNMPObjectIdentifier(String string) throws SNMPBadValueException {
        this.convertDigitString(string);
    }

    public SNMPObjectIdentifier(int[] nArray) throws SNMPBadValueException {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0) {
                throw new SNMPBadValueException("Negative value supplied for SNMPObjectIdentifier.");
            }
            ++n;
        }
        this.digits = nArray;
    }

    public SNMPObjectIdentifier(byte[] byArray) throws SNMPBadValueException {
        this.extractFromBEREncoding(byArray);
    }

    public Object getValue() {
        return this.digits;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof int[]) {
            int n = 0;
            while (n < ((int[])object).length) {
                if (((int[])object)[n] < 0) {
                    throw new SNMPBadValueException("Negative value supplied for SNMPObjectIdentifier.");
                }
                ++n;
            }
            this.digits = (int[])object;
        } else if (object instanceof String) {
            this.convertDigitString((String)object);
        } else {
            throw new SNMPBadValueException(" Object Identifier: bad object supplied to set value ");
        }
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 6;
        byte[] byArray = this.encodeArray();
        byte[] byArray2 = SNMPBERCodec.encodeLength(byArray.length);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] encodeArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.digits.length;
        if (n >= 2) {
            byteArrayOutputStream.write((byte)(40 * this.digits[0] + this.digits[1]));
        } else if (n == 1) {
            byteArrayOutputStream.write((byte)(40 * this.digits[0]));
        }
        int n2 = 2;
        while (n2 < n) {
            byte[] byArray = this.encodeValue(this.digits[n2]);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            ++n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] encodeValue(int n) {
        int n2 = 0;
        int n3 = n;
        do {
            ++n2;
        } while ((n3 = (int)Math.floor(n3 / 128)) > 0);
        byte[] byArray = new byte[n2];
        byArray[n2 - 1] = (byte)(n % 128);
        n = (int)Math.floor(n / 128);
        int n4 = n2 - 2;
        while (n4 >= 0) {
            byArray[n4] = (byte)(n % 128 + 128);
            n = (int)Math.floor(n / 128);
            --n4;
        }
        return byArray;
    }

    private void convertDigitString(String string) throws SNMPBadValueException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                stringTokenizer.nextToken();
            }
            int[] nArray = new int[n];
            stringTokenizer = new StringTokenizer(string, " .");
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                if (nArray[n2] < 0) {
                    throw new SNMPBadValueException(" Object Identifier: bad string supplied to set value ");
                }
                ++n2;
            }
            this.digits = nArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SNMPBadValueException(" Object Identifier: bad string supplied for object identifier value ");
        }
    }

    private void extractFromBEREncoding(byte[] byArray) throws SNMPBadValueException {
        int n = 128;
        int n2 = 127;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if ((byArray[n4] & n) == 0) {
                ++n3;
            }
            ++n4;
        }
        if (n3 > 0) {
            this.digits = new int[n3 + 1];
            int n5 = -1;
            int n6 = 0;
            do {
                n6 = n6 * 128 + (byArray[++n5] & n2);
            } while ((byArray[n5] & n) > 0);
            this.digits[0] = (int)Math.floor(n6 / 40);
            this.digits[1] = n6 % 40;
            int n7 = 2;
            while (n7 < n3 + 1) {
                n6 = 0;
                do {
                    n6 = n6 * 128 + (byArray[++n5] & n2);
                } while ((byArray[n5] & n) > 0);
                this.digits[n7] = n6;
                ++n7;
            }
        } else {
            this.digits = new int[0];
        }
    }

    public boolean equals(SNMPObjectIdentifier sNMPObjectIdentifier) {
        int[] nArray = (int[])sNMPObjectIdentifier.getValue();
        boolean bl = true;
        if (this.digits.length != nArray.length) {
            bl = false;
        } else {
            int n = 0;
            while (n < this.digits.length) {
                if (this.digits[n] != nArray[n]) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public String toString() {
        String string = new String();
        if (this.digits.length > 0) {
            string = String.valueOf(string) + this.digits[0];
            int n = 1;
            while (n < this.digits.length) {
                string = String.valueOf(string) + "." + this.digits[n];
                ++n;
            }
        }
        return string;
    }
}

