/*
 * Decompiled with CFR 0.152.
 */
package jacorb.concurrency;

import jacorb.concurrency.LockCoordinatorImpl;
import jacorb.concurrency.LockSetFactoryImpl;
import jacorb.concurrency.TransactionalLockSetImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosConcurrencyControl.LockCoordinator;
import org.omg.CosConcurrencyControl.LockCoordinatorHelper;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.ResourcePOA;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;

class TransactionCoordinator
extends ResourcePOA {
    static final int ACTIVE = 0;
    static final int COMMITED = 1;
    static final int PREPARED = 2;
    static final int ROLLEDBACK = 3;
    private Coordinator current;
    private POA poa;
    private Hashtable locksets = new Hashtable();
    private int state;
    private LockSetFactoryImpl factory;

    TransactionCoordinator(LockSetFactoryImpl lockSetFactoryImpl, Coordinator coordinator, POA pOA) {
        this.current = coordinator;
        this.poa = pOA;
        this.factory = lockSetFactoryImpl;
        Status status = coordinator.get_status();
        if (status.equals(Status.StatusActive)) {
            this.state = 0;
        } else if (status.equals(Status.StatusPrepared) || status.equals(Status.StatusPreparing)) {
            this.state = 2;
        } else if (status.equals(Status.StatusCommitted) || status.equals(Status.StatusUnknown) || status.equals(Status.StatusNoTransaction) || status.equals(Status.StatusCommitting)) {
            this.state = 1;
        } else if (status.equals(Status.StatusRollingBack) || status.equals(Status.StatusMarkedRollback) || status.equals(Status.StatusRolledBack)) {
            this.state = 3;
        }
    }

    private void check_state() {
        if (this.state == 2 || this.state == 1) {
            throw new INVALID_TRANSACTION();
        }
        if (this.state == 3) {
            throw new TRANSACTION_ROLLEDBACK();
        }
    }

    public synchronized void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        if (this.state != 2) {
            throw new NotPrepared();
        }
        this.state = 1;
        this.run();
    }

    public synchronized void commit_one_phase() throws HeuristicHazard {
        if (this.state == 0) {
            this.state = 1;
            this.run();
        }
    }

    public synchronized void forget() {
        throw new NO_IMPLEMENT();
    }

    Coordinator get_coordinator() {
        return this.current;
    }

    synchronized LockCoordinator get_lock_coordinator(TransactionalLockSetImpl transactionalLockSetImpl) {
        LockCoordinatorImpl lockCoordinatorImpl = (LockCoordinatorImpl)this.locksets.get(transactionalLockSetImpl);
        if (lockCoordinatorImpl == null) {
            lockCoordinatorImpl = new LockCoordinatorImpl(this, transactionalLockSetImpl);
            this.locksets.put(transactionalLockSetImpl, lockCoordinatorImpl);
        }
        try {
            return LockCoordinatorHelper.narrow(this.poa.servant_to_reference(lockCoordinatorImpl));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    synchronized Status get_state() {
        switch (this.state) {
            case 0: {
                return Status.StatusActive;
            }
            case 1: {
                return Status.StatusCommitted;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 3: {
                return Status.StatusRolledBack;
            }
        }
        return Status.StatusNoTransaction;
    }

    public synchronized Vote prepare() throws HeuristicMixed, HeuristicHazard {
        if (this.state == 0) {
            this.state = 2;
            return Vote.VoteCommit;
        }
        return Vote.VoteRollback;
    }

    synchronized void remove_coordinator(TransactionalLockSetImpl transactionalLockSetImpl) {
        LockCoordinatorImpl lockCoordinatorImpl = (LockCoordinatorImpl)this.locksets.get(transactionalLockSetImpl);
        if (lockCoordinatorImpl != null) {
            try {
                byte[] byArray = this.poa.servant_to_id(lockCoordinatorImpl);
                this.poa.deactivate_object(byArray);
            }
            catch (Exception exception) {}
            this.locksets.remove(transactionalLockSetImpl);
        }
    }

    public synchronized void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        if (this.state == 0) {
            this.state = 3;
            this.run();
        }
    }

    public void run() {
        Enumeration enumeration = this.locksets.elements();
        while (enumeration.hasMoreElements()) {
            LockCoordinatorImpl lockCoordinatorImpl = (LockCoordinatorImpl)enumeration.nextElement();
            lockCoordinatorImpl.drop_locks();
            try {
                byte[] byArray = this.poa.servant_to_id(lockCoordinatorImpl);
                this.poa.deactivate_object(byArray);
            }
            catch (ServantNotActive servantNotActive) {
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
        this.factory.remove_me(this);
    }

    synchronized void set_lock_coordinator(TransactionalLockSetImpl transactionalLockSetImpl) {
        this.check_state();
        LockCoordinatorImpl lockCoordinatorImpl = (LockCoordinatorImpl)this.locksets.get(transactionalLockSetImpl);
        if (lockCoordinatorImpl == null) {
            lockCoordinatorImpl = new LockCoordinatorImpl(this, transactionalLockSetImpl);
            this.locksets.put(transactionalLockSetImpl, lockCoordinatorImpl);
        }
    }
}

