/*
 * Decompiled with CFR 0.152.
 */
package jacorb.imr;

import jacorb.imr.ImRServerInfo;
import jacorb.imr.POAInfo;
import jacorb.imr.RegistrationPackage.IllegalPOAName;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.io.Serializable;

public class ImRPOAInfo
implements Serializable {
    protected int port;
    protected ImRServerInfo server;
    protected String host;
    protected String name;
    protected boolean active;
    protected static long timeout;

    static {
        block2: {
            timeout = 120000L;
            String string = Environment.getProperty("jacorb.imr.timeout");
            if (string == null) break block2;
            try {
                timeout = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
    }

    public ImRPOAInfo(String string, String string2, int n, ImRServerInfo imRServerInfo) throws IllegalPOAName {
        if (string == null || string.length() == 0) {
            throw new IllegalPOAName(string);
        }
        this.name = string;
        this.host = string2;
        this.port = n;
        this.server = imRServerInfo;
        this.active = true;
    }

    public synchronized boolean awaitActivation() {
        while (!this.active) {
            try {
                long l = System.currentTimeMillis();
                this.wait(timeout);
                if (this.active || System.currentTimeMillis() - l <= timeout) continue;
                Debug.output(2050, "awaitActivation, time_out");
                return false;
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
            }
        }
        Debug.output(2050, "awaitActivation, returns true");
        return true;
    }

    public synchronized void reactivate(String string, int n) {
        this.host = string;
        this.port = n;
        this.active = true;
        this.server.active = true;
        this.server.restarting = false;
        this.notifyAll();
    }

    public POAInfo toPOAInfo() {
        return new POAInfo(this.name, this.host, this.port, this.server.name, this.active);
    }
}

