/*
 * Decompiled with CFR 0.152.
 */
package jacorb.imr;

import jacorb.imr.AdminPackage.IllegalServerName;
import jacorb.imr.ImRPOAInfo;
import jacorb.imr.POAInfo;
import jacorb.imr.RessourceLock;
import jacorb.imr.ServerInfo;
import jacorb.util.Debug;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ImRServerInfo
implements Serializable {
    protected String command;
    protected boolean holding = false;
    protected String host;
    protected String name;
    protected boolean active;
    protected boolean restarting = false;
    private Vector poas = null;
    private RessourceLock poas_lock = null;

    public ImRServerInfo(String string, String string2, String string3) throws IllegalServerName {
        if (string == null || string.length() == 0) {
            throw new IllegalServerName(string);
        }
        this.name = string;
        this.host = string2;
        this.command = string3;
        this.active = false;
        this.poas = new Vector();
        this.poas_lock = new RessourceLock();
    }

    public void addPOA(ImRPOAInfo imRPOAInfo) {
        if (!this.active) {
            this.active = true;
        }
        this.poas_lock.gainSharedLock();
        this.poas.addElement(imRPOAInfo);
        this.poas_lock.releaseSharedLock();
    }

    public synchronized void awaitRelease() {
        while (this.holding) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                Debug.output(2050, exception);
            }
        }
    }

    protected String[] getPOANames() {
        String[] stringArray = new String[this.poas.size()];
        Enumeration enumeration = this.poas.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = ((ImRPOAInfo)enumeration.nextElement()).name;
        }
        return stringArray;
    }

    public synchronized void release() {
        this.holding = false;
        this.notifyAll();
    }

    public void setDown() {
        int n = 0;
        while (n < this.poas.size()) {
            ((ImRPOAInfo)this.poas.elementAt((int)n)).active = false;
            ++n;
        }
        this.active = false;
        this.restarting = false;
    }

    public synchronized boolean shouldBeRestarted() {
        boolean bl = (this.active || this.restarting) ^ true;
        if (bl) {
            this.restarting = true;
        }
        return bl;
    }

    public ServerInfo toServerInfo() {
        this.poas_lock.gainExclusiveLock();
        POAInfo[] pOAInfoArray = new POAInfo[this.poas.size()];
        Enumeration enumeration = this.poas.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            pOAInfoArray[n++] = ((ImRPOAInfo)enumeration.nextElement()).toPOAInfo();
        }
        this.poas_lock.releaseExclusiveLock();
        return new ServerInfo(this.name, this.command, pOAInfoArray, this.host, this.active, this.holding);
    }
}

