/*
 * Decompiled with CFR 0.152.
 */
package jacorb.imr;

import jacorb.imr.AdminPackage.DuplicateServerName;
import jacorb.imr.HostInfo;
import jacorb.imr.ImRHostInfo;
import jacorb.imr.ImRPOAInfo;
import jacorb.imr.ImRServerInfo;
import jacorb.imr.POAInfo;
import jacorb.imr.RessourceLock;
import jacorb.imr.ServerInfo;
import jacorb.imr.UnknownServerName;
import jacorb.util.Environment;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ServerTable
implements Serializable {
    private Hashtable servers;
    private transient RessourceLock servers_lock;
    private Hashtable poas;
    private transient RessourceLock poas_lock;
    private Hashtable hosts;
    private transient RessourceLock hosts_lock;
    public transient RessourceLock table_lock;

    public ServerTable() {
        int n = 100;
        int n2 = 5;
        try {
            n = Integer.parseInt(Environment.getProperty("jacorb.imr.no_of_poas"));
        }
        catch (Exception exception) {}
        try {
            n2 = Integer.parseInt(Environment.getProperty("jacorb.imr.no_of_servers"));
        }
        catch (Exception exception) {}
        this.servers = new Hashtable((int)(1.3333333333333333 * (double)n2));
        this.poas = new Hashtable((int)(1.3333333333333333 * (double)n));
        this.hosts = new Hashtable();
        this.initTransient();
    }

    public ImRHostInfo getHost(String string) {
        return (ImRHostInfo)this.hosts.get(string);
    }

    public HostInfo[] getHosts() {
        this.table_lock.gainSharedLock();
        this.hosts_lock.gainExclusiveLock();
        HostInfo[] hostInfoArray = new HostInfo[this.hosts.size()];
        Enumeration enumeration = this.hosts.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            hostInfoArray[n++] = ((ImRHostInfo)enumeration.nextElement()).toHostInfo();
        }
        this.hosts_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return hostInfoArray;
    }

    public ImRPOAInfo getPOA(String string) {
        return (ImRPOAInfo)this.poas.get(string);
    }

    public POAInfo[] getPOAs() {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainExclusiveLock();
        POAInfo[] pOAInfoArray = new POAInfo[this.poas.size()];
        Enumeration enumeration = this.poas.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            pOAInfoArray[n++] = ((ImRPOAInfo)enumeration.nextElement()).toPOAInfo();
        }
        this.poas_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return pOAInfoArray;
    }

    public ImRServerInfo getServer(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = (ImRServerInfo)this.servers.get(string);
        if (imRServerInfo == null) {
            throw new UnknownServerName(string);
        }
        return imRServerInfo;
    }

    public ServerInfo[] getServers() {
        this.table_lock.gainSharedLock();
        this.servers_lock.gainExclusiveLock();
        ServerInfo[] serverInfoArray = new ServerInfo[this.servers.size()];
        Enumeration enumeration = this.servers.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serverInfoArray[n++] = ((ImRServerInfo)enumeration.nextElement()).toServerInfo();
        }
        this.servers_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return serverInfoArray;
    }

    private void initTransient() {
        this.table_lock = new RessourceLock();
        this.servers_lock = new RessourceLock();
        this.poas_lock = new RessourceLock();
        this.hosts_lock = new RessourceLock();
    }

    public void putHost(String string, ImRHostInfo imRHostInfo) {
        this.table_lock.gainSharedLock();
        this.hosts_lock.gainSharedLock();
        this.hosts.put(string, imRHostInfo);
        this.hosts_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public void putPOA(String string, ImRPOAInfo imRPOAInfo) {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainSharedLock();
        this.poas.put(string, imRPOAInfo);
        this.poas_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public void putServer(String string, ImRServerInfo imRServerInfo) throws DuplicateServerName {
        if (this.servers.containsKey(string)) {
            throw new DuplicateServerName(string);
        }
        this.table_lock.gainSharedLock();
        this.servers_lock.gainSharedLock();
        this.servers.put(string, imRServerInfo);
        this.servers_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTransient();
    }

    public Object removeHost(String string) {
        return this.hosts.remove(string);
    }

    public void removePOA(String string) {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainSharedLock();
        this.poas.remove(string);
        this.poas_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public void removeServer(String string) throws UnknownServerName {
        this.table_lock.gainSharedLock();
        this.servers_lock.gainSharedLock();
        Object v = this.servers.remove(string);
        this.servers_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
        if (v == null) {
            throw new UnknownServerName(string);
        }
    }
}

