/*
 * Decompiled with CFR 0.152.
 */
package jacorb.naming;

import java.io.Serializable;
import java.util.Vector;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class Name
implements Serializable {
    private NameComponent[] fullName;
    private NameComponent baseName;
    private NameComponent[] ctxName;

    public Name() {
        this.fullName = null;
        this.baseName = null;
        this.ctxName = null;
    }

    public Name(String string) throws InvalidName {
        this(Name.toName(string));
    }

    public Name(NameComponent nameComponent) throws InvalidName {
        if (nameComponent == null) {
            throw new InvalidName();
        }
        this.baseName = nameComponent;
        this.fullName = new NameComponent[1];
        this.fullName[0] = nameComponent;
        this.ctxName = null;
    }

    public Name(NameComponent[] nameComponentArray) throws InvalidName {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        this.fullName = nameComponentArray;
        this.baseName = nameComponentArray[nameComponentArray.length - 1];
        if (nameComponentArray.length > 1) {
            this.ctxName = new NameComponent[nameComponentArray.length - 1];
            int n = 0;
            while (n < nameComponentArray.length - 1) {
                this.ctxName[n] = nameComponentArray[n];
                ++n;
            }
        } else {
            this.ctxName = null;
        }
    }

    public NameComponent baseNameComponent() {
        return this.baseName;
    }

    public NameComponent[] components() {
        return this.fullName;
    }

    public Name ctxName() {
        if (this.ctxName != null) {
            try {
                return new Name(this.ctxName);
            }
            catch (InvalidName invalidName) {
                invalidName.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Name)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '/' || stringBuffer.charAt(n) == '\\' || stringBuffer.charAt(n) == '.') {
                stringBuffer.insert(n, '\\');
                ++n;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Name fullName() throws InvalidName {
        return new Name(this.fullName);
    }

    private static NameComponent getComponent(String string) throws InvalidName {
        NameComponent nameComponent = new NameComponent("", "");
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '.') {
                if (n2 == string.length() - 1 && n2 > 0) {
                    throw new InvalidName();
                }
                if (n2 > 0 && string.charAt(n2 - 1) != '\\') {
                    if (n < n2) {
                        nameComponent.id = string.substring(n, n2);
                    }
                    if (n2 < string.length()) {
                        nameComponent.kind = string.substring(n2 + 1);
                    }
                    return nameComponent;
                }
                if (n2 < string.length()) {
                    nameComponent.kind = string.substring(n2 + 1);
                }
                return nameComponent;
            }
            ++n2;
        }
        nameComponent.id = string;
        return nameComponent;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String kind() {
        return this.baseName.kind;
    }

    public static NameComponent[] toName(String string) throws InvalidName {
        if (string.startsWith("/")) {
            throw new InvalidName();
        }
        Vector<NameComponent> vector = new Vector<NameComponent>();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '/' && string.charAt(n2 - 1) != '\\') {
                if (n2 - n == 0) {
                    throw new InvalidName();
                }
                vector.addElement(Name.getComponent(string.substring(n, n2)));
                n = n2 + 1;
            }
            ++n2;
        }
        if (n < n2) {
            vector.addElement(Name.getComponent(string.substring(n, n2)));
        }
        NameComponent[] nameComponentArray = new NameComponent[vector.size()];
        int n3 = 0;
        while (n3 < nameComponentArray.length) {
            nameComponentArray[n3] = (NameComponent)vector.elementAt(n3);
            ++n3;
        }
        return nameComponentArray;
    }

    public String toString() {
        try {
            return Name.toString(this.fullName);
        }
        catch (InvalidName invalidName) {
            return "<invalid>";
        }
    }

    public static String toString(NameComponent[] nameComponentArray) throws InvalidName {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nameComponentArray.length) {
            if (n > 0) {
                stringBuffer.append("/");
            }
            if (nameComponentArray[n].id.length() > 0) {
                stringBuffer.append(Name.escape(nameComponentArray[n].id));
            }
            if (nameComponentArray[n].kind.length() > 0 || nameComponentArray[n].id.length() == 0) {
                stringBuffer.append(".");
            }
            if (nameComponentArray[n].kind.length() > 0) {
                stringBuffer.append(Name.escape(nameComponentArray[n].kind));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

