/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.util.Debug;
import java.util.Vector;

class BufferManager {
    private Vector[] bufferPool = new Vector[20];
    private static final int MAX = 20;
    private static final int MIN_OFFSET = 5;
    private static final int THREASHOLD = 15;
    private int hits = 0;
    private int calls = 0;

    public BufferManager() {
        int n = 20;
        while (n > 0) {
            this.bufferPool[--n] = new Vector();
        }
    }

    synchronized byte[] getBuffer(int n) {
        ++this.calls;
        int n2 = BufferManager.log2up(n);
        if (n2 > 25) {
            return new byte[n];
        }
        Vector vector = this.bufferPool[n2 > 5 ? n2 - 5 : 0];
        if (!vector.isEmpty()) {
            ++this.hits;
            Object e = vector.firstElement();
            vector.removeElementAt(0);
            return (byte[])e;
        }
        return new byte[n2 > 5 ? 1 << n2 : 32];
    }

    private static final int log2down(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    private static final int log2up(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n]);
            System.out.println("log2up(" + n2 + "): " + BufferManager.log2up(n2));
            System.out.println("log2down(" + n2 + "): " + BufferManager.log2down(n2));
            ++n;
        }
    }

    public void printStatistics() {
        System.out.println("BufferManager statistics:");
        System.out.println("\t get Buffer called: " + this.calls);
        System.out.println("\t buffers found in pool: " + this.hits);
        System.out.println("\t buffers size: ");
        int n = 20;
        while (n > 0) {
            System.out.println("\t size 2**" + (5 + --n) + " # " + this.bufferPool[n].size());
        }
    }

    public void release() {
        int n = 20;
        while (n > 0) {
            this.bufferPool[--n].removeAllElements();
        }
    }

    synchronized void returnBuffer(byte[] byArray) {
        int n = BufferManager.log2down(byArray.length);
        Debug.output(4, "return buffer: " + byArray.length + " bytes, log2: " + n);
        if (n >= 10) {
            if (n > 20) {
                return;
            }
            Vector vector = this.bufferPool[n - 5];
            if (vector.size() < 15) {
                vector.addElement(byArray);
            }
        }
    }
}

