/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain.gui;

import jacorb.orb.ORB;
import jacorb.orb.domain.Domain;
import jacorb.orb.domain.DomainHelper;
import jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import jacorb.orb.domain.InvalidName;
import jacorb.orb.domain.ManagementPolicy;
import jacorb.orb.domain.ManagementPolicyHelper;
import jacorb.orb.domain.MetaPropertyPolicy;
import jacorb.orb.domain.NameAlreadyDefined;
import jacorb.orb.domain.PolicyTypeAlreadyDefined;
import jacorb.orb.domain.PropertyPolicy;
import jacorb.orb.domain.gui.AboutDialog;
import jacorb.orb.domain.gui.Browser;
import jacorb.orb.domain.gui.DomainTreeCellRenderer;
import jacorb.orb.domain.gui.DomainTreeNode;
import jacorb.orb.domain.gui.MemberListLeafNode;
import jacorb.orb.domain.gui.MemberListRootNode;
import jacorb.orb.domain.gui.PolicyEditor;
import jacorb.orb.domain.gui.PolicyListCellRenderer;
import jacorb.orb.domain.gui.PolicyListLeafNode;
import jacorb.orb.domain.gui.PolicyListRootNode;
import jacorb.orb.domain.gui.PopupMenuActivator;
import jacorb.orb.domain.gui.PropertyDialog;
import jacorb.orb.domain.gui.ScrollableTextPane;
import jacorb.orb.domain.gui.SharedData;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;

public class BrowserFrame
extends JFrame {
    JPanel contentPane;
    JMenuBar menuBar1 = new JMenuBar();
    JMenu DomainMenu = new JMenu();
    JMenuItem ExitMenuItem = new JMenuItem();
    JMenu HelpMenu = new JMenu();
    JMenuItem AboutMenuItem = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane outerSplitPane = new JSplitPane();
    JScrollPane TreeScrollPane = new JScrollPane();
    JTree jTree1 = null;
    DefaultTreeModel treeModel = null;
    private BrowserFrame mainFrame;
    private org.omg.CORBA.ORB orb = null;
    Domain theRootDomain = null;
    Domain orbDomain = null;
    Object memberBuffer = null;
    String memberNameBuffer = null;
    DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
    DomainTreeCellRenderer domainTreeCellRenderer = new DomainTreeCellRenderer();
    PolicyListCellRenderer policyListCellRenderer = new PolicyListCellRenderer();
    private PolicyListRootNode policyListRoot;
    private MemberListRootNode memberListRoot;
    private SharedData theSharedData;
    JMenu ViewMenu = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JPopupMenu PolicyPopupMenu = new JPopupMenu();
    JPopupMenu TreePopupMenu = new JPopupMenu();
    JMenuItem UpdateMenuItem = new JMenuItem();
    JSplitPane innerSplitPane = new JSplitPane();
    JScrollPane MemberScrollPane = new JScrollPane();
    JScrollPane PolicyScrollPane = new JScrollPane();
    JTree policyList = new JTree();
    JPopupMenu MemberPopupMenu = new JPopupMenu();
    JMenuItem PolicyPropertyMenuItem = new JMenuItem();
    JMenuItem PropertiesMenuItem = new JMenuItem();
    JCheckBoxMenuItem showToolTipsMenuItem = new JCheckBoxMenuItem();
    JMenuItem RenameMenuItem = new JMenuItem();
    JMenuItem DomainRenameItem = new JMenuItem();
    JTree memberList = new JTree();
    JMenuItem DomainNewMenuItem = new JMenuItem();
    JMenuItem CutMenuItem = new JMenuItem();
    JMenuItem PolicyCutMenuItem = new JMenuItem();
    JMenuItem DomainCutMenuItem = new JMenuItem();
    JMenuItem CopyMenuItem = new JMenuItem();
    JMenuItem PasteMenuItem = new JMenuItem();
    JMenuItem DomainLoadMenuItem = new JMenuItem();
    JMenuItem CloseMenuItem = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JMenuItem PolicyCopyMenuItem = new JMenuItem();
    JMenuItem PolicyPasteMenuItem = new JMenuItem();
    JMenu PolicyNewMenu = new JMenu();
    JMenuItem PolicyNewPropertyPolicyMenuItem = new JMenuItem();
    JMenuItem PolicyNewMetaPropertyPolicyMenuItem = new JMenuItem();
    JMenuItem DomainCopyMenuItem = new JMenuItem();
    JMenuItem DomainPasteMenuItem = new JMenuItem();

    public BrowserFrame(SharedData sharedData) {
        this.mainFrame = this;
        this.theSharedData = sharedData;
        Domain domain = null;
        this.enableEvents(64L);
        try {
            domain = this.getDomainServer();
            this.check(domain);
            this.initTree(domain);
            this.jbInit();
            this.theSharedData.registerFrame(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BrowserFrame(SharedData sharedData, Domain domain) {
        this.mainFrame = this;
        this.theSharedData = sharedData;
        this.enableEvents(64L);
        try {
            this.initTree(domain);
            this.jbInit();
            this.theSharedData.registerFrame(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void OnDomainClose(ActionEvent actionEvent) {
        this.releaseRessources();
        this.hide();
        this.dispose();
    }

    void OnDomainLoad(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            Domain domain = this.readDomainFromFile(jFileChooser.getSelectedFile(), this.getORB());
            if (domain != null) {
                this.theRootDomain = domain;
                DomainTreeNode domainTreeNode = new DomainTreeNode(domain);
                this.treeModel = new DefaultTreeModel(domainTreeNode);
                this.jTree1.setModel(this.treeModel);
                this.updateListModels(this.theRootDomain);
            } else {
                Debug.output(2, "OnDomainLoad: domain is null");
            }
        }
    }

    void OnDomainNew(ActionEvent actionEvent) {
        DomainTreeNode domainTreeNode = (DomainTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (domainTreeNode == null) {
            return;
        }
        Domain domain = domainTreeNode.getDomain();
        Domain domain2 = domain.createEmptyDomain();
        domain2.name("new Domain");
        try {
            domain.insertChild(domain2);
        }
        catch (ClosesCycle closesCycle) {
            Debug.output(32769, "could not insert new domain because of closing cycle");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please choose another name.", "Name Already in Use", 0);
        }
        this.updateTreeView(domainTreeNode);
    }

    void OnDomainPopupCopy(ActionEvent actionEvent) {
        DomainTreeNode domainTreeNode = (DomainTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (domainTreeNode == null) {
            return;
        }
        Domain domain = domainTreeNode.getDomain();
        this.theSharedData.setDomainBuffer(domain);
    }

    void OnDomainPopupCut(ActionEvent actionEvent) {
        int n;
        DomainTreeNode domainTreeNode = (DomainTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (domainTreeNode == null) {
            return;
        }
        Domain domain = domainTreeNode.getDomain();
        if (domain.getChildCount() != 0 && (n = JOptionPane.showConfirmDialog(this, "The domain to remove has childs. Please confirm  removing of domain by pressing yes. ", "Confirm Remove", 0)) != 0) {
            return;
        }
        TreeNode treeNode = domainTreeNode.getParent();
        if (treeNode == null) {
            return;
        }
        DomainTreeNode domainTreeNode2 = (DomainTreeNode)treeNode;
        Domain domain2 = domainTreeNode2.getDomain();
        domain2.deleteChild(domain);
        this.theSharedData.setDomainBuffer(domain);
        this.updateTreeView(domainTreeNode2);
    }

    void OnDomainPopupPaste(ActionEvent actionEvent) {
        DomainTreeNode domainTreeNode = (DomainTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (domainTreeNode == null) {
            domainTreeNode = (DomainTreeNode)this.treeModel.getRoot();
        }
        Domain domain = domainTreeNode.getDomain();
        try {
            domain.insertChild(this.theSharedData.getDomainBuffer());
        }
        catch (ClosesCycle closesCycle) {
            JOptionPane.showMessageDialog(this, "This operation would close a cycle in in the domain graph and is therefore not permitted.", "Paste Impossible", 0);
            return;
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            JOptionPane.showMessageDialog(this, "The name " + nameAlreadyDefined.name + "is already" + " used in the target domain by another child. Rename that child first.", "Name already in use", 0);
            return;
        }
        this.updateTreeView(domainTreeNode);
    }

    void OnDomainPopupRemove(ActionEvent actionEvent) {
    }

    void OnHelpAbout(ActionEvent actionEvent) {
        AboutDialog aboutDialog = new AboutDialog(this, "about the domain browser", false);
        aboutDialog.show();
    }

    void OnMemberPopupCopy(ActionEvent actionEvent) {
        Object object = null;
        Debug.assert(1, this.memberListRoot != null, "root of member list is null");
        int n = this.memberList.getMinSelectionRow();
        if (n < 0) {
            return;
        }
        Debug.output(32772, "selected index is " + n);
        MemberListLeafNode memberListLeafNode = (MemberListLeafNode)this.memberListRoot.getChildAt(n);
        object = memberListLeafNode.getObject();
        this.theSharedData.setMemberBuffer(object, memberListLeafNode.toString());
        this.PasteMenuItem.setEnabled(true);
    }

    void OnMemberPopupCut(ActionEvent actionEvent) {
        Object object = null;
        Debug.assert(1, this.memberListRoot != null, "root of member list is null");
        int n = this.memberList.getMinSelectionRow();
        if (n < 0) {
            return;
        }
        Debug.output(32772, "selected index is " + n);
        MemberListLeafNode memberListLeafNode = (MemberListLeafNode)this.memberListRoot.getChildAt(n);
        object = memberListLeafNode.getObject();
        try {
            Domain domain = this.memberListRoot.getDomain();
            domain.deleteMember(object);
            this.theSharedData.setMemberBuffer(object, memberListLeafNode.toString());
            this.PasteMenuItem.setEnabled(true);
            this.memberListRoot = new MemberListRootNode(domain);
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.memberListRoot);
            this.memberList.setModel(defaultTreeModel);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            JOptionPane.showMessageDialog(this.mainFrame, "The domain containing the member does not reply. Operation canceled.", "Broken Connection", 1);
        }
    }

    void OnMemberPopupPaste(ActionEvent actionEvent) {
        Debug.assert(1, this.memberListRoot != null, "root of member list is null");
        Debug.assert(1, this.theSharedData.MemberBufferIsEmpty() ^ true, "member buffer is empty");
        Domain domain = this.memberListRoot.getDomain();
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.theSharedData.getMemberBuffer(stringBuffer);
        String string = new String(stringBuffer);
        try {
            domain.insertMemberWithName(string, object);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            JOptionPane.showMessageDialog(this, "The member name " + string + " is already in use in the target domain. \nPlease rename member " + "before copying / cuting.", "Member Name Already in Use", 0);
            return;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            JOptionPane.showMessageDialog(this.mainFrame, "The target domain does not reply. Operation canceled.", "Broken Connection", 1);
            return;
        }
        this.memberListRoot = new MemberListRootNode(domain);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.memberListRoot);
        this.memberList.setModel(defaultTreeModel);
    }

    void OnMemberPopupProperties(ActionEvent actionEvent) {
        Object object = null;
        Debug.assert(1, this.memberListRoot != null, "root of member list is null");
        int n = this.memberList.getMinSelectionRow();
        if (n < 0) {
            return;
        }
        Debug.output(32772, "selected index is " + n);
        MemberListLeafNode memberListLeafNode = (MemberListLeafNode)this.memberListRoot.getChildAt(n);
        object = memberListLeafNode.getObject();
        String string = memberListLeafNode.toString();
        if (object == null) {
            return;
        }
        PropertyDialog propertyDialog = new PropertyDialog(object, this, "Member Properties", true);
        propertyDialog.show();
    }

    void OnMemberPopupRename(ActionEvent actionEvent) {
        ((DefaultTreeCellEditor)this.memberList.getCellEditor()).actionPerformed(actionEvent);
    }

    void OnPolicyPopupCopy(ActionEvent actionEvent) {
        Debug.assert(1, this.policyListRoot != null, "root of policy list is null");
        int n = this.policyList.getMinSelectionRow();
        if (n < 0) {
            return;
        }
        PolicyListLeafNode policyListLeafNode = (PolicyListLeafNode)this.policyListRoot.getChildAt(n);
        Policy policy = policyListLeafNode.getPolicy();
        this.theSharedData.setPolicyBuffer(policy);
    }

    void OnPolicyPopupCut(ActionEvent actionEvent) {
        Debug.assert(1, this.policyListRoot != null, "root of policy list is null");
        int n = this.policyList.getMinSelectionRow();
        if (n < 0) {
            return;
        }
        PolicyListLeafNode policyListLeafNode = (PolicyListLeafNode)this.policyListRoot.getChildAt(n);
        Policy policy = policyListLeafNode.getPolicy();
        try {
            Domain domain = this.policyListRoot.getDomain();
            domain.deletePolicyOfType(policy.policy_type());
            this.theSharedData.setPolicyBuffer(policy);
            this.enablePolicyPasteMenuItem();
            this.policyListRoot = new PolicyListRootNode(domain);
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.policyListRoot);
            this.policyList.setModel(defaultTreeModel);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            JOptionPane.showMessageDialog(this, "The policy / domain does not reply. Operation canceled.", "Broken Connection", 1);
        }
    }

    void OnPolicyPopupNewMetaPropertyPolicy(ActionEvent actionEvent) {
        java.lang.Object object;
        int n;
        Debug.assert(1, this.policyListRoot != null, "root of policy list is null");
        Domain domain = this.policyListRoot.getDomain();
        MetaPropertyPolicy metaPropertyPolicy = null;
        String string = "Property";
        String string2 = "?";
        String string3 = "?";
        string = JOptionPane.showInputDialog(this, (java.lang.Object)"Step 1 of 3: Enter name for property Policy");
        if (string == null) {
            return;
        }
        string2 = JOptionPane.showInputDialog(this, (java.lang.Object)"Step 2 of 3: Enter type for property Policy");
        if (string2 == null) {
            return;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Could not convert input to number.", numberFormatException.toString(), 0);
            return;
        }
        string3 = JOptionPane.showInputDialog(this, (java.lang.Object)"Step 3 of 3: Enter policy types for which this policy shall be meta. \n Please separate the types by a comma (\",\").");
        if (string == null) {
            return;
        }
        metaPropertyPolicy = domain.createMetaPropertyPolicy();
        metaPropertyPolicy.name(string);
        metaPropertyPolicy.setPolicyType(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                continue;
            }
            ++n2;
        }
        if (n2 == stringTokenizer.countTokens()) {
            metaPropertyPolicy.setTypesResponsibleFor(nArray);
        } else {
            object = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                object[n3] = nArray[n3];
                ++n3;
            }
            metaPropertyPolicy.setTypesResponsibleFor((int[])object);
        }
        try {
            domain.set_domain_policy(metaPropertyPolicy);
        }
        catch (PolicyTypeAlreadyDefined policyTypeAlreadyDefined) {
            JOptionPane.showMessageDialog(this, "The policy type." + n + " is used by another policy of this domain. Choose another type.", "Policy Type Already in Use", 0);
            return;
        }
        this.policyListRoot = new PolicyListRootNode(domain);
        object = new DefaultTreeModel(this.policyListRoot);
        this.policyList.setModel((TreeModel)object);
    }

    void OnPolicyPopupNewPropertyPolicy(ActionEvent actionEvent) {
        int n;
        Debug.assert(1, this.policyListRoot != null, "root of policy list is null");
        Domain domain = this.policyListRoot.getDomain();
        PropertyPolicy propertyPolicy = null;
        String string = "Property";
        String string2 = "?";
        string = JOptionPane.showInputDialog(this, (java.lang.Object)"Step 1 of 2: Enter name for property Policy");
        if (string == null) {
            return;
        }
        string2 = JOptionPane.showInputDialog(this, (java.lang.Object)"Step 2 of 2: Enter type for property Policy");
        if (string2 == null) {
            return;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Could not convert input to number.", numberFormatException.toString(), 0);
            return;
        }
        propertyPolicy = domain.createPropertyPolicy();
        propertyPolicy.name(string);
        propertyPolicy.setPolicyType(n);
        try {
            domain.set_domain_policy(propertyPolicy);
        }
        catch (PolicyTypeAlreadyDefined policyTypeAlreadyDefined) {
            JOptionPane.showMessageDialog(this, "The policy type." + n + " is used by another policy of this domain. Choose another type.", "Policy Type Already in Use", 0);
            return;
        }
        this.policyListRoot = new PolicyListRootNode(domain);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.policyListRoot);
        this.policyList.setModel(defaultTreeModel);
    }

    void OnPolicyPopupPaste(ActionEvent actionEvent) {
        Debug.assert(1, this.policyListRoot != null, "root of policy list is null");
        Domain domain = this.policyListRoot.getDomain();
        try {
            domain.set_domain_policy(this.theSharedData.getPolicyBuffer());
        }
        catch (PolicyTypeAlreadyDefined policyTypeAlreadyDefined) {
            int n = JOptionPane.showConfirmDialog(this, "The policy type " + policyTypeAlreadyDefined.type + " is used by another policy of this domain. Override this policy ?", "Policy Type Already Defined", 0);
            if (n == 0) {
                domain.overwrite_domain_policy(this.theSharedData.getPolicyBuffer());
            }
            return;
        }
        DomainTreeNode domainTreeNode = (DomainTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (domainTreeNode == null) {
            return;
        }
        this.policyListRoot = new PolicyListRootNode(domainTreeNode.getDomain());
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.policyListRoot);
        this.policyList.setModel(defaultTreeModel);
    }

    void OnPolicyPopupProperties(ActionEvent actionEvent) {
        Debug.assert(1, this.policyListRoot != null, "root of policy list is null");
        int n = this.policyList.getMinSelectionRow();
        if (n < 0) {
            return;
        }
        PolicyListLeafNode policyListLeafNode = (PolicyListLeafNode)this.policyListRoot.getChildAt(n);
        Policy policy = policyListLeafNode.getPolicy();
        if (policy == null) {
            return;
        }
        try {
            PropertyDialog propertyDialog = new PropertyDialog(policy, this, "Policy Properties", true);
            ManagementPolicy managementPolicy = ManagementPolicyHelper.narrow(policy);
            if (managementPolicy != null) {
                propertyDialog.setTitle(String.valueOf(managementPolicy.short_description()) + " Properties");
                propertyDialog.add("Description", new ScrollableTextPane(managementPolicy.long_description()));
            }
            if (this.theSharedData.getPolicyEditors() == null) {
                propertyDialog.show();
                return;
            }
            int n2 = policy.policy_type();
            String string = Integer.toString(n2);
            String string2 = this.theSharedData.getPolicyEditors().getValueOfProperty(string);
            Debug.output(32771, "class name for policy type " + n2 + " is " + string2);
            if (string2 == null) {
                Debug.output(32770, "no editor for policy type " + n2 + " available");
                propertyDialog.show();
                return;
            }
            try {
                PolicyEditor policyEditor = (PolicyEditor)Class.forName(string2).newInstance();
                policyEditor.setEditorPolicy(policy);
                propertyDialog.add(policyEditor.getTitle(), policyEditor.getGraphicalComponent());
            }
            catch (Exception exception) {
                Debug.output(32769, exception.toString());
            }
            propertyDialog.show();
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            JOptionPane.showMessageDialog(this.mainFrame, "The policy domain does not reply. Operation canceled.", "Broken Connection", 1);
        }
    }

    void OnTreeNodesChanged(TreeModelEvent treeModelEvent) {
        DomainTreeNode domainTreeNode = (DomainTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        if (domainTreeNode == null) {
            return;
        }
        try {
            int n = treeModelEvent.getChildIndices()[0];
            domainTreeNode = (DomainTreeNode)domainTreeNode.getChildAt(n);
        }
        catch (NullPointerException nullPointerException) {}
    }

    void OnTreePopupRename(ActionEvent actionEvent) {
        ((DefaultTreeCellEditor)this.jTree1.getCellEditor()).actionPerformed(actionEvent);
    }

    void OnViewNewFrame(ActionEvent actionEvent) {
        new Browser(this.theSharedData, this.theRootDomain);
    }

    void OnViewToolTips(ActionEvent actionEvent) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
        if (jCheckBoxMenuItem.isSelected()) {
            this.jTree1.setCellRenderer(this.domainTreeCellRenderer);
            this.policyList.setCellRenderer(this.policyListCellRenderer);
        } else {
            this.jTree1.setCellRenderer(this.defaultTreeCellRenderer);
            this.policyList.setCellRenderer(this.defaultTreeCellRenderer);
        }
    }

    void OnViewUpdate(ActionEvent actionEvent) {
        DomainTreeNode domainTreeNode = (DomainTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (domainTreeNode == null) {
            domainTreeNode = (DomainTreeNode)this.treeModel.getRoot();
        }
        this.updateTreeView(domainTreeNode);
    }

    private void check(Domain domain) {
        if (domain._non_existent()) {
            Debug.output(0, "call to domain server failed, reference invalid ?");
            Debug.output(0, "cannot continue, exiting.");
            System.exit(-1);
        }
    }

    public void enableDomainPasteMenuItem() {
        this.DomainPasteMenuItem.setEnabled(true);
    }

    public void enableMemberPasteMenuItem() {
        this.PasteMenuItem.setEnabled(true);
    }

    public void enablePolicyPasteMenuItem() {
        this.PolicyPasteMenuItem.setEnabled(true);
    }

    public void fileExit_actionPerformed(ActionEvent actionEvent) {
        this.releaseRessources();
        try {
            this.getDomainServer().deleteChild(this.getORBDomain());
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            Debug.output(32770, "BrowserFrame.OnExit:  unmounting of gui orb domain not possible, skipping.");
        }
        ((ORB)this.getORB()).shutdown(false);
        System.exit(0);
    }

    public Domain getDomainServer() {
        Domain domain = null;
        Debug.output(32771, "URL of domain service: " + Environment.DomainServiceURL());
        try {
            domain = DomainHelper.narrow(this.getORB().resolve_initial_references("DomainService"));
            Debug.assert(1, domain != null, "domain server not running");
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            Debug.output(1, "domain service not found at orb, cannot continue.");
            System.exit(-1);
        }
        catch (Exception exception) {
            Debug.output(1, exception);
            System.exit(-1);
        }
        return domain;
    }

    public org.omg.CORBA.ORB getORB() {
        return this.theSharedData.getORB();
    }

    public Domain getORBDomain() {
        return this.theSharedData.getORBDomain();
    }

    private void initTree(Domain domain) {
        if (domain == null) {
            Debug.output(32769, " BrowserFrame.initTree: parameter  RootDomain is not valid (==null), canceling.");
            return;
        }
        this.theRootDomain = domain;
        DomainTreeNode domainTreeNode = new DomainTreeNode(this.theRootDomain);
        this.treeModel = new DefaultTreeModel(domainTreeNode);
        this.jTree1 = new JTree(this.treeModel);
        this.jTree1.getSelectionModel().setSelectionMode(1);
        this.jTree1.putClientProperty("JTree.lineStyle", "Angled");
        ToolTipManager.sharedInstance().registerComponent(this.jTree1);
        ToolTipManager.sharedInstance().registerComponent(this.policyList);
        this.jTree1.setCellRenderer(this.domainTreeCellRenderer);
        this.policyList.setCellRenderer(this.policyListCellRenderer);
        this.updateTreeView(domainTreeNode);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DomainTreeNode domainTreeNode = (DomainTreeNode)BrowserFrame.this.jTree1.getLastSelectedPathComponent();
                if (domainTreeNode == null) {
                    return;
                }
                BrowserFrame.this.DomainRenameItem.setEnabled(true);
                Domain domain = domainTreeNode.getDomain();
                try {
                    BrowserFrame.this.updateListModels(domain);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    Debug.output(32770, "The selected domain does not reply.  Removing it from domain graph ...");
                    DomainTreeNode domainTreeNode2 = (DomainTreeNode)domainTreeNode.getParent();
                    if (domainTreeNode2 == null) {
                        Debug.output(32769, " valueChanged: cannot  remove root domain, cancel removing.");
                        return;
                    }
                    Domain domain2 = domainTreeNode2.getDomain();
                    domain2.deleteChild(domain);
                    JOptionPane.showMessageDialog(BrowserFrame.this.mainFrame, "The domain does not reply. \n Removing domain", "Broken Connection", 1);
                    BrowserFrame.this.updateTreeView(domainTreeNode2);
                }
            }
        });
        this.jTree1.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
                DomainTreeNode domainTreeNode = (DomainTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (domainTreeNode == null) {
                    return;
                }
                if (domainTreeNode.viewNeedsUpdate) {
                    BrowserFrame.this.updateTreeView(domainTreeNode);
                }
            }
        });
        this.jTree1.setCellEditor(new DefaultTreeCellEditor(this.jTree1, new DefaultTreeCellRenderer()));
        this.jTree1.getCellEditor().addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent changeEvent) {
            }

            public void editingStopped(ChangeEvent changeEvent) {
                DomainTreeNode domainTreeNode = (DomainTreeNode)BrowserFrame.this.jTree1.getLastSelectedPathComponent();
                if (domainTreeNode == null) {
                    return;
                }
                TreeNode treeNode = domainTreeNode.getParent();
                if (treeNode == null) {
                    return;
                }
                Domain domain = domainTreeNode.getDomain();
                DomainTreeNode domainTreeNode2 = (DomainTreeNode)treeNode;
                Domain domain2 = domainTreeNode2.getDomain();
                String string = "???";
                try {
                    String string2 = domainTreeNode.toString();
                    string = domain.name();
                    Debug.output(32773, "name before edit: " + string);
                    Debug.output(32773, "name after  edit: " + string2);
                    if (string2.equals(string)) {
                        return;
                    }
                    domain2.renameChildDomain(string, string2);
                }
                catch (NameAlreadyDefined nameAlreadyDefined) {
                    JOptionPane.showMessageDialog(BrowserFrame.this.mainFrame, "Please choose another name.", "Name Already in Use", 0);
                    domainTreeNode.setUserObject(string);
                    ((DefaultTreeModel)BrowserFrame.this.jTree1.getModel()).nodeChanged(domainTreeNode);
                }
                catch (InvalidName invalidName) {
                    Debug.output(1, invalidName);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    JOptionPane.showMessageDialog(BrowserFrame.this.mainFrame, "The domain does not reply. Operation canceled.", "Broken Connection", 1);
                    domainTreeNode.setUserObject(string);
                    ((DefaultTreeModel)BrowserFrame.this.jTree1.getModel()).nodeChanged(domainTreeNode);
                }
            }
        });
        JMenuItem[] jMenuItemArray = new JMenuItem[]{this.DomainRenameItem, this.DomainCutMenuItem, this.DomainCopyMenuItem, this.UpdateMenuItem};
        this.jTree1.addMouseListener(new PopupMenuActivator(this.TreePopupMenu, this.jTree1, jMenuItemArray));
        this.updateListModels(this.theRootDomain.createEmptyDomain());
        JMenuItem[] jMenuItemArray2 = new JMenuItem[]{this.PropertiesMenuItem, this.CutMenuItem, this.CopyMenuItem, this.RenameMenuItem};
        this.memberList.addMouseListener(new PopupMenuActivator(this.MemberPopupMenu, this.memberList, jMenuItemArray2));
        this.memberList.getSelectionModel().setSelectionMode(1);
        this.memberList.setCellEditor(new DefaultTreeCellEditor(this.memberList, new DefaultTreeCellRenderer()));
        this.memberList.getCellEditor().addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent changeEvent) {
            }

            public void editingStopped(ChangeEvent changeEvent) {
                Object object = null;
                String string = "???";
                Debug.assert(1, BrowserFrame.this.memberListRoot != null, "root of member list is null");
                int n = BrowserFrame.this.memberList.getMinSelectionRow();
                MemberListLeafNode memberListLeafNode = (MemberListLeafNode)BrowserFrame.this.memberListRoot.getChildAt(n);
                object = memberListLeafNode.getObject();
                try {
                    String string2 = memberListLeafNode.toString();
                    string = BrowserFrame.this.memberListRoot.getDomain().getNameOf(object);
                    Debug.output(32773, "name before edit: " + string);
                    Debug.output(32773, "name after  edit: " + string2);
                    if (string2.equals(string)) {
                        return;
                    }
                    BrowserFrame.this.memberListRoot.getDomain().renameMember(string, string2);
                }
                catch (NameAlreadyDefined nameAlreadyDefined) {
                    JOptionPane.showMessageDialog(BrowserFrame.this.mainFrame, "Please choose another name.", "Name Already in Use", 0);
                    memberListLeafNode.setName(string);
                    int[] nArray = new int[]{n};
                    ((DefaultTreeModel)BrowserFrame.this.memberList.getModel()).nodesChanged(BrowserFrame.this.memberListRoot, nArray);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    JOptionPane.showMessageDialog(BrowserFrame.this.mainFrame, "The domain containing the member does not reply. Operation canceled.", "Broken Connection", 1);
                    memberListLeafNode.setName(string);
                    int[] nArray = new int[]{n};
                    ((DefaultTreeModel)BrowserFrame.this.memberList.getModel()).nodesChanged(BrowserFrame.this.memberListRoot, nArray);
                }
                catch (InvalidName invalidName) {
                    Debug.output(1, invalidName);
                }
            }
        });
        this.MemberScrollPane.setColumnHeaderView(new JLabel("Members", 0));
        JMenuItem[] jMenuItemArray3 = new JMenuItem[]{this.PolicyPropertyMenuItem, this.PolicyCutMenuItem, this.PolicyCopyMenuItem};
        this.policyList.addMouseListener(new PopupMenuActivator(this.PolicyPopupMenu, this.policyList, jMenuItemArray3));
        this.policyList.getSelectionModel().setSelectionMode(1);
        this.PolicyScrollPane.setColumnHeaderView(new JLabel("Policies", 0));
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(400, 300));
        this.setTitle("Domain Browser");
        this.DomainMenu.setMnemonic('D');
        this.DomainMenu.setText("Domain");
        this.ExitMenuItem.setToolTipText("exit program");
        this.ExitMenuItem.setMnemonic('X');
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.fileExit_actionPerformed(actionEvent);
            }
        });
        this.HelpMenu.setMnemonic('H');
        this.HelpMenu.setText("Help");
        this.AboutMenuItem.setToolTipText("show about box");
        this.AboutMenuItem.setMnemonic('A');
        this.AboutMenuItem.setText("About");
        this.AboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnHelpAbout(actionEvent);
            }
        });
        this.ViewMenu.setMnemonic('V');
        this.ViewMenu.setText("View");
        this.jMenuItem1.setToolTipText("update view of current domain");
        this.jMenuItem1.setMnemonic('U');
        this.jMenuItem1.setText("Update");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnViewUpdate(actionEvent);
            }
        });
        this.UpdateMenuItem.setText("Update");
        this.UpdateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnViewUpdate(actionEvent);
            }
        });
        this.outerSplitPane.setOneTouchExpandable(true);
        this.innerSplitPane.setOrientation(0);
        this.innerSplitPane.setOneTouchExpandable(true);
        this.PolicyPropertyMenuItem.setText("Properties");
        this.PolicyPropertyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnPolicyPopupProperties(actionEvent);
            }
        });
        this.PropertiesMenuItem.setText("Properties ...");
        this.PropertiesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnMemberPopupProperties(actionEvent);
            }
        });
        this.jTree1.setToolTipText("");
        this.jTree1.setEditable(true);
        this.showToolTipsMenuItem.setToolTipText("enable / disable tool tips");
        this.showToolTipsMenuItem.setSelected(true);
        this.showToolTipsMenuItem.setMnemonic('T');
        this.showToolTipsMenuItem.setText("Tool Tips");
        this.showToolTipsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnViewToolTips(actionEvent);
            }
        });
        this.RenameMenuItem.setText("Rename");
        this.RenameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnMemberPopupRename(actionEvent);
            }
        });
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                BrowserFrame.this.OnTreeNodesChanged(treeModelEvent);
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        this.DomainRenameItem.setEnabled(false);
        this.DomainRenameItem.setText("Rename");
        this.DomainRenameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnTreePopupRename(actionEvent);
            }
        });
        this.memberList.setEditable(true);
        this.memberList.setRootVisible(false);
        this.policyList.setRootVisible(false);
        this.DomainNewMenuItem.setToolTipText("create a new empty domain");
        this.DomainNewMenuItem.setMnemonic('N');
        this.DomainNewMenuItem.setText("New");
        this.DomainNewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnDomainNew(actionEvent);
            }
        });
        this.CutMenuItem.setToolTipText("delete member");
        this.CutMenuItem.setMnemonic('T');
        this.CutMenuItem.setText("Cut");
        this.CutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnMemberPopupCut(actionEvent);
            }
        });
        this.PolicyCutMenuItem.setToolTipText("delete policy");
        this.PolicyCutMenuItem.setMnemonic('T');
        this.PolicyCutMenuItem.setText("Cut");
        this.PolicyCutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnPolicyPopupCut(actionEvent);
            }
        });
        this.DomainCutMenuItem.setToolTipText("remove domain");
        this.DomainCutMenuItem.setMnemonic('T');
        this.DomainCutMenuItem.setText("Cut");
        this.DomainCutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnDomainPopupCut(actionEvent);
            }
        });
        this.CopyMenuItem.setToolTipText("copy into buffer");
        this.CopyMenuItem.setMnemonic('C');
        this.CopyMenuItem.setText("Copy");
        this.CopyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnMemberPopupCopy(actionEvent);
            }
        });
        this.PasteMenuItem.setEnabled(false);
        this.PasteMenuItem.setToolTipText("paste object");
        this.PasteMenuItem.setMnemonic('P');
        this.PasteMenuItem.setText("Paste");
        this.PasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnMemberPopupPaste(actionEvent);
            }
        });
        this.DomainLoadMenuItem.setToolTipText("load root domain from file");
        this.DomainLoadMenuItem.setMnemonic('O');
        this.DomainLoadMenuItem.setText("Load ...");
        this.DomainLoadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnDomainLoad(actionEvent);
            }
        });
        this.CloseMenuItem.setToolTipText("close the current frame");
        this.CloseMenuItem.setMnemonic('C');
        this.CloseMenuItem.setText("Close");
        this.CloseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnDomainClose(actionEvent);
            }
        });
        this.jMenuItem3.setToolTipText("create a new browser frame");
        this.jMenuItem3.setMnemonic('F');
        this.jMenuItem3.setText("new Frame");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnViewNewFrame(actionEvent);
            }
        });
        this.PolicyCopyMenuItem.setToolTipText("copy polic into policy buffer");
        this.PolicyCopyMenuItem.setMnemonic('C');
        this.PolicyCopyMenuItem.setText("Copy");
        this.PolicyCopyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnPolicyPopupCopy(actionEvent);
            }
        });
        this.PolicyPasteMenuItem.setEnabled(false);
        this.PolicyPasteMenuItem.setToolTipText("paste policy from policy buffer");
        this.PolicyPasteMenuItem.setMnemonic('P');
        this.PolicyPasteMenuItem.setText("Paste");
        this.PolicyPasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnPolicyPopupPaste(actionEvent);
            }
        });
        this.PolicyNewMenu.setToolTipText("create new policy");
        this.PolicyNewMenu.setText("New");
        this.PolicyNewPropertyPolicyMenuItem.setToolTipText("(name, value) pairs");
        this.PolicyNewPropertyPolicyMenuItem.setMnemonic('P');
        this.PolicyNewPropertyPolicyMenuItem.setText("Property Policy");
        this.PolicyNewPropertyPolicyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnPolicyPopupNewPropertyPolicy(actionEvent);
            }
        });
        this.PolicyNewMetaPropertyPolicyMenuItem.setToolTipText("(name, value) + meta");
        this.PolicyNewMetaPropertyPolicyMenuItem.setMnemonic('M');
        this.PolicyNewMetaPropertyPolicyMenuItem.setText("MetaPropertyPolicy");
        this.PolicyNewMetaPropertyPolicyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnPolicyPopupNewMetaPropertyPolicy(actionEvent);
            }
        });
        this.DomainCopyMenuItem.setToolTipText("copy domain into domain buffer");
        this.DomainCopyMenuItem.setMnemonic('C');
        this.DomainCopyMenuItem.setText("Copy");
        this.DomainCopyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnDomainPopupCopy(actionEvent);
            }
        });
        this.DomainPasteMenuItem.setEnabled(false);
        this.DomainPasteMenuItem.setToolTipText("paste domain from domain buffer");
        this.DomainPasteMenuItem.setMnemonic('P');
        this.DomainPasteMenuItem.setText("Paste");
        this.DomainPasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserFrame.this.OnDomainPopupPaste(actionEvent);
            }
        });
        this.DomainMenu.add(this.DomainNewMenuItem);
        this.DomainMenu.add(this.DomainLoadMenuItem);
        this.DomainMenu.addSeparator();
        this.DomainMenu.add(this.CloseMenuItem);
        this.DomainMenu.add(this.ExitMenuItem);
        this.HelpMenu.add(this.AboutMenuItem);
        this.menuBar1.add(this.DomainMenu);
        this.menuBar1.add(this.ViewMenu);
        this.menuBar1.add(this.HelpMenu);
        this.ViewMenu.add(this.jMenuItem3);
        this.ViewMenu.add(this.jMenuItem1);
        this.ViewMenu.add(this.showToolTipsMenuItem);
        this.TreePopupMenu.add(this.UpdateMenuItem);
        this.TreePopupMenu.add(this.DomainCutMenuItem);
        this.TreePopupMenu.add(this.DomainCopyMenuItem);
        this.TreePopupMenu.add(this.DomainPasteMenuItem);
        this.TreePopupMenu.add(this.DomainRenameItem);
        this.contentPane.add((Component)this.outerSplitPane, "Center");
        this.outerSplitPane.add((Component)this.TreeScrollPane, "left");
        this.outerSplitPane.add((Component)this.innerSplitPane, "right");
        this.innerSplitPane.add((Component)this.MemberScrollPane, "left");
        this.MemberScrollPane.getViewport().add((Component)this.memberList, null);
        this.innerSplitPane.add((Component)this.PolicyScrollPane, "right");
        this.PolicyScrollPane.getViewport().add((Component)this.policyList, null);
        this.TreeScrollPane.getViewport().add((Component)this.jTree1, null);
        this.PolicyPopupMenu.add(this.PolicyPropertyMenuItem);
        this.PolicyPopupMenu.add(this.PolicyCutMenuItem);
        this.PolicyPopupMenu.add(this.PolicyCopyMenuItem);
        this.PolicyPopupMenu.add(this.PolicyPasteMenuItem);
        this.PolicyPopupMenu.add(this.PolicyNewMenu);
        this.MemberPopupMenu.add(this.PropertiesMenuItem);
        this.MemberPopupMenu.add(this.CutMenuItem);
        this.MemberPopupMenu.add(this.CopyMenuItem);
        this.MemberPopupMenu.add(this.PasteMenuItem);
        this.MemberPopupMenu.add(this.RenameMenuItem);
        this.PolicyNewMenu.add(this.PolicyNewPropertyPolicyMenuItem);
        this.PolicyNewMenu.add(this.PolicyNewMetaPropertyPolicyMenuItem);
        this.setJMenuBar(this.menuBar1);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.fileExit_actionPerformed(null);
        }
    }

    private Domain readDomainFromFile(File file, org.omg.CORBA.ORB oRB) {
        String string = null;
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 2048);
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                string = string2;
                while (string2 != null) {
                    string2 = bufferedReader.readLine();
                    if (string2 == null) continue;
                    string = String.valueOf(string) + string2;
                }
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Reading of file was not possible.\n Reason: " + iOException.toString(), "Error while reading file", 1);
            return null;
        }
        try {
            return DomainHelper.narrow(oRB.string_to_object(string));
        }
        catch (RuntimeException runtimeException) {
            JOptionPane.showMessageDialog(this, "Parsing of file was not possible.\n Reason: " + runtimeException.toString(), "Error while parsing file", 1);
            return null;
        }
    }

    private void releaseRessources() {
        this.theSharedData.deregisterFrame(this);
    }

    private void updateListModels(Domain domain) {
        this.memberListRoot = new MemberListRootNode(domain);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.memberListRoot);
        this.memberList.setModel(defaultTreeModel);
        this.policyListRoot = new PolicyListRootNode(domain);
        DefaultTreeModel defaultTreeModel2 = new DefaultTreeModel(this.policyListRoot);
        this.policyList.setModel(defaultTreeModel2);
    }

    public void updateTreeView(DomainTreeNode domainTreeNode) {
        Domain domain = domainTreeNode.getDomain();
        Domain[] domainArray = domain.getChilds();
        Debug.output(32771, "updating node " + domain.name());
        Debug.output(32771, "before remove " + domainTreeNode.getChildCount());
        int[] nArray = new int[domainTreeNode.getChildCount()];
        java.lang.Object[] objectArray = new java.lang.Object[domainTreeNode.getChildCount()];
        int n = 0;
        while (n < domainTreeNode.getChildCount()) {
            nArray[n] = n;
            objectArray[n] = domainTreeNode.getChildAt(n);
            ++n;
        }
        domainTreeNode.removeAllChildren();
        this.treeModel.nodesWereRemoved(domainTreeNode, nArray, objectArray);
        Debug.output(5, "after remove " + domainTreeNode.getChildCount());
        int n2 = 0;
        while (n2 < domainArray.length) {
            this.treeModel.insertNodeInto(new DomainTreeNode(domainArray[n2]), domainTreeNode, n2);
            ++n2;
        }
        this.treeModel.nodeChanged(domainTreeNode);
        Debug.output(5, "after insertion " + domainTreeNode.getChildCount());
        domainTreeNode.viewNeedsUpdate = false;
    }
}

