/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain.gui;

import jacorb.orb.domain.PropertyAlreadyDefined;
import jacorb.orb.domain.PropertyPolicy;
import jacorb.orb.domain.PropertyPolicyHelper;
import jacorb.orb.domain.PropertyPolicyImpl;
import jacorb.orb.domain.gui.DefaultPolicyEditor;
import jacorb.orb.domain.gui.PropertyTableModel;
import jacorb.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omg.CORBA.Policy;

public class PropertyEditor
extends DefaultPolicyEditor {
    private PropertyTableModel theTableModel;
    private boolean _useWarningMessagesOnDelete = false;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane TableScrollPane = new JScrollPane();
    JPanel MainPanel = new JPanel();
    Box ButtonBox;
    JTable PropertyTable = new JTable();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton NewButton = new JButton();
    JButton DeleteButton = new JButton();
    JLabel PolicyLabel = new JLabel();
    Component component1;
    JButton LoadButton = new JButton();
    JButton StoreButton = new JButton();

    public PropertyEditor() {
        this._useWarningMessagesOnDelete = true;
    }

    public PropertyEditor(PropertyPolicy propertyPolicy) {
        this(propertyPolicy, true);
    }

    public PropertyEditor(PropertyPolicy propertyPolicy, boolean bl) {
        super(propertyPolicy);
        try {
            this._useWarningMessagesOnDelete = bl;
            this.jbInit();
            this.MyInit(propertyPolicy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void MyInit(PropertyPolicy propertyPolicy) {
        this.PolicyLabel.setText(String.valueOf(propertyPolicy.name()) + " (type " + propertyPolicy.policy_type() + ")");
        this.theTableModel = new PropertyTableModel(propertyPolicy);
        this.PropertyTable.setModel(this.theTableModel);
        this.PropertyTable.setSelectionMode(1);
        ListSelectionModel listSelectionModel = this.PropertyTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Debug.output(32772, listSelectionEvent.toString());
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                PropertyEditor.this.DeleteButton.setEnabled(listSelectionModel.isSelectionEmpty() ^ true);
            }
        });
    }

    void OnButtonDelete(ActionEvent actionEvent) {
        int n;
        ListSelectionModel listSelectionModel = this.PropertyTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return;
        }
        PropertyTableModel propertyTableModel = (PropertyTableModel)this.PropertyTable.getModel();
        PropertyPolicy propertyPolicy = propertyTableModel.getPropertyPolicy();
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        if (this._useWarningMessagesOnDelete && (n = JOptionPane.showConfirmDialog(this, "Do you really want to  delete row(s) " + n2 + " to " + n3 + "?", "Confirm Deletion", 0)) == 1) {
            return;
        }
        int n4 = n2;
        while (n4 <= n3) {
            String string = propertyTableModel.getNameAt(n4);
            propertyPolicy.removeProperty(string);
            Debug.output(32774, "detected name " + string + " at index " + n4);
            ++n4;
        }
        propertyTableModel.setPropertyPolicy(propertyPolicy);
        this.DeleteButton.setEnabled(false);
        propertyTableModel.fireTableRowsDeleted(n2, n3);
    }

    void OnButtonLoad(ActionEvent actionEvent) {
        block2: {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) break block2;
            try {
                PropertyPolicyImpl.loadFromFile(this.theTableModel.getPropertyPolicy(), jFileChooser.getSelectedFile(), "jacorb.policy.");
                this.theTableModel.update();
                this.theTableModel.fireTableDataChanged();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException, "Input Error", 0);
            }
        }
    }

    void OnButtonNew(ActionEvent actionEvent) {
        PropertyTableModel propertyTableModel = (PropertyTableModel)this.PropertyTable.getModel();
        PropertyPolicy propertyPolicy = propertyTableModel.getPropertyPolicy();
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        int n = 0;
        while (!bl) {
            try {
                propertyPolicy.put(String.valueOf(string3) + string, string2);
                propertyTableModel.setPropertyPolicy(propertyPolicy);
                int n2 = propertyTableModel.getIndex(string);
                propertyTableModel.fireTableRowsInserted(n2, n2);
                bl = true;
            }
            catch (PropertyAlreadyDefined propertyAlreadyDefined) {
                Debug.output(32774, "PropertyEditor.OnButtonNew: prop " + string3 + string + "already defined");
                string3 = "NEW " + ++n;
                bl = false;
            }
        }
    }

    void OnButtonStore(ActionEvent actionEvent) {
        block2: {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) break block2;
            try {
                PropertyPolicyImpl.storeToFile(this.theTableModel.getPropertyPolicy(), jFileChooser.getSelectedFile(), "jacorb.policy.");
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException, "Output Error", 0);
            }
        }
    }

    public int getPolicyTypeResponsibleFor() {
        return 112;
    }

    public PropertyTableModel getTableModel() {
        return this.theTableModel;
    }

    public String getTitle() {
        return "Properties";
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createVerticalStrut(8);
        this.NewButton.setToolTipText("create a new entry in the table");
        this.NewButton.setMnemonic('N');
        this.NewButton.setText("New");
        this.NewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.OnButtonNew(actionEvent);
            }
        });
        this.ButtonBox = Box.createVerticalBox();
        this.setLayout(this.borderLayout1);
        this.MainPanel.setLayout(this.borderLayout2);
        this.DeleteButton.setEnabled(false);
        this.DeleteButton.setToolTipText("delete the selected row(s)");
        this.DeleteButton.setMnemonic('T');
        this.DeleteButton.setText("Delete");
        this.DeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.OnButtonDelete(actionEvent);
            }
        });
        this.PolicyLabel.setFont(new Font("Serif", 1, 14));
        this.PolicyLabel.setToolTipText("");
        this.PolicyLabel.setHorizontalAlignment(0);
        this.PolicyLabel.setText("name and id");
        this.LoadButton.setToolTipText("load/merge table entries from file");
        this.LoadButton.setMnemonic('O');
        this.LoadButton.setText("Load ...");
        this.LoadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.OnButtonLoad(actionEvent);
            }
        });
        this.StoreButton.setToolTipText("store table entries to file");
        this.StoreButton.setMnemonic('S');
        this.StoreButton.setText("Store ...");
        this.StoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.OnButtonStore(actionEvent);
            }
        });
        this.add((Component)this.MainPanel, "Center");
        this.MainPanel.add((Component)this.ButtonBox, "East");
        this.ButtonBox.add((Component)this.NewButton, null);
        this.ButtonBox.add((Component)this.DeleteButton, null);
        this.ButtonBox.add(this.component1, null);
        this.ButtonBox.add((Component)this.LoadButton, null);
        this.ButtonBox.add((Component)this.StoreButton, null);
        this.MainPanel.add((Component)this.TableScrollPane, "Center");
        this.MainPanel.add((Component)this.PolicyLabel, "North");
        this.TableScrollPane.getViewport().add((Component)this.PropertyTable, null);
    }

    public void setEditorPolicy(Policy policy) {
        this._policy = policy;
        try {
            this.jbInit();
            this.MyInit(PropertyPolicyHelper.narrow(policy));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTableModel(PropertyTableModel propertyTableModel) {
        this.theTableModel = propertyTableModel;
    }
}

