/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain.gui;

import jacorb.orb.domain.PropertyAlreadyDefined;
import jacorb.orb.domain.PropertyPolicy;
import jacorb.orb.domain.Util;
import jacorb.util.Debug;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class PropertyTableModel
extends AbstractTableModel {
    private PropertyPolicy thePropertyPolicy;
    private String[] theValidNames;

    PropertyTableModel(PropertyPolicy propertyPolicy) {
        this.thePropertyPolicy = propertyPolicy;
        this.update();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Property Name";
        }
        return "Property Value";
    }

    public int getIndex(String string) {
        int n = 0;
        while (n < this.theValidNames.length) {
            if (this.theValidNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getNameAt(int n) {
        return this.theValidNames[n];
    }

    public PropertyPolicy getPropertyPolicy() {
        return this.thePropertyPolicy;
    }

    public int getRowCount() {
        return this.thePropertyPolicy.getPropertyCount();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.theValidNames[n];
        }
        return this.thePropertyPolicy.getValueOfProperty(this.theValidNames[n]);
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void setPropertyPolicy(PropertyPolicy propertyPolicy) {
        this.thePropertyPolicy = propertyPolicy;
        this.update();
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = (String)object;
        Debug.output(32772, "TableModel.setValueAt: value has changed to " + string + " @ (" + n + "," + n2 + ")");
        if (n2 == 0) {
            String string2 = this.theValidNames[n];
            if (string2.equals(string)) {
                return;
            }
            if (this.thePropertyPolicy.containsProperty(string)) {
                JOptionPane.showMessageDialog(null, "The new name is already in  use. Names must be unique. Please choose another one.", " Error", 0);
                return;
            }
            String string3 = this.thePropertyPolicy.getValueOfProperty(string2);
            this.thePropertyPolicy.removeProperty(string2);
            try {
                this.thePropertyPolicy.put(string, string3);
            }
            catch (PropertyAlreadyDefined propertyAlreadyDefined) {
                Debug.output(32772, "property name " + string2 + " already defined.");
            }
            this.theValidNames[n] = string;
        } else {
            this.thePropertyPolicy.changeValueOfProperty(this.theValidNames[n], string);
        }
    }

    public void update() {
        this.theValidNames = this.thePropertyPolicy.getPropertyNames();
        Util.quicksort(0, this.theValidNames.length - 1, this.theValidNames);
    }
}

