/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain.gui;

import jacorb.orb.ORB;
import jacorb.orb.domain.Domain;
import jacorb.orb.domain.DomainHelper;
import jacorb.orb.domain.PolicyTypeAlreadyDefined;
import jacorb.orb.domain.PropertyPolicy;
import jacorb.orb.domain.PropertyPolicyImpl;
import jacorb.orb.domain.gui.BrowserFrame;
import jacorb.orb.domain.gui.SharedData;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;

public class SharedDataImpl
implements SharedData {
    private Hashtable _frames;
    private org.omg.CORBA.ORB _orb;
    private Domain _orbDomain;
    private PropertyPolicy _policyEditors;
    private Object _memberBuffer = null;
    private String _memberNameBuffer = null;
    private java.lang.Object _memberLock = new java.lang.Object();
    private Policy _policyBuffer = null;
    private java.lang.Object _policyLock = new java.lang.Object();
    private Domain _domainBuffer = null;
    private java.lang.Object _domainLock = new java.lang.Object();

    SharedDataImpl() {
        this._frames = new Hashtable(10);
        this.initPropertyPolicy();
    }

    SharedDataImpl(org.omg.CORBA.ORB oRB) {
        this();
        this._orb = oRB;
    }

    public boolean DomainBufferIsEmpty() {
        java.lang.Object object = this._domainLock;
        synchronized (object) {
            boolean bl = this._domainBuffer == null;
            java.lang.Object var3_3 = null;
            return bl;
        }
    }

    public boolean MemberBufferIsEmpty() {
        java.lang.Object object = this._memberLock;
        synchronized (object) {
            boolean bl = this._memberBuffer == null;
            java.lang.Object var3_3 = null;
            return bl;
        }
    }

    public boolean PolicyBufferIsEmpty() {
        java.lang.Object object = this._policyLock;
        synchronized (object) {
            boolean bl = this._policyBuffer == null;
            java.lang.Object var3_3 = null;
            return bl;
        }
    }

    public synchronized void deregisterFrame(BrowserFrame browserFrame) {
        this._frames.remove(browserFrame);
        if (this.getFrameCount() == 0) {
            try {
                browserFrame.getDomainServer().deleteChild(this.getORBDomain());
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                Debug.output(32770, "SharedDataImpl.deregisterFrame:  unmounting of gui orb domain not possible, skipping.");
            }
            ((ORB)this._orb).shutdown(false);
            System.exit(0);
        }
    }

    public Domain getDomainBuffer() {
        java.lang.Object object = this._domainLock;
        synchronized (object) {
            Domain domain = this._domainBuffer;
            java.lang.Object var3_3 = null;
            return domain;
        }
    }

    public synchronized int getFrameCount() {
        return this._frames.size();
    }

    public Object getMemberBuffer(StringBuffer stringBuffer) {
        java.lang.Object object = this._memberLock;
        synchronized (object) {
            stringBuffer.append(this._memberNameBuffer);
            Object object2 = this._memberBuffer;
            java.lang.Object var4_4 = null;
            return object2;
        }
    }

    public org.omg.CORBA.ORB getORB() {
        if (this._orb == null) {
            this._orb = this.initORB();
        }
        return this._orb;
    }

    public Domain getORBDomain() {
        block3: {
            if (this._orbDomain != null) break block3;
            try {
                this._orbDomain = DomainHelper.narrow(this.getORB().resolve_initial_references("LocalDomainService"));
                Debug.assert(1, this._orbDomain != null, "orb domain  not running");
            }
            catch (InvalidName invalidName) {
                Debug.output(1, "local orb domain not found at orb");
            }
            catch (Exception exception) {
                Debug.output(1, exception);
            }
        }
        return this._orbDomain;
    }

    public Policy getPolicyBuffer() {
        java.lang.Object object = this._policyLock;
        synchronized (object) {
            Policy policy = this._policyBuffer;
            java.lang.Object var3_3 = null;
            return policy;
        }
    }

    public PropertyPolicy getPolicyEditors() {
        Debug.assert(1, this._policyEditors != null, "SharedDataImpl.PolicyEditors: _policyEditorsis null");
        return this._policyEditors;
    }

    private org.omg.CORBA.ORB initORB() {
        Debug.output(2, "orb initializing");
        org.omg.CORBA.ORB oRB = null;
        ORB oRB2 = null;
        try {
            oRB = org.omg.CORBA.ORB.init(new String[0], null);
            oRB2 = (ORB)oRB;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            System.out.println("SharedDataImpl.initORB: " + cOMM_FAILURE + ", cannot continue.");
            System.exit(-1);
        }
        catch (Exception exception) {
            Debug.output(1, exception);
        }
        try {
            Debug.output(32774, " before insert GUI orb domain");
            oRB2.mountORBDomain("GUI orb domain");
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            Debug.output(32770, "SharedDataImpl.initORB: " + cOMM_FAILURE + ", skipping mounting of gui orb domain.");
        }
        catch (Exception exception) {
            Debug.output(1, exception);
        }
        Debug.output(2, "orb initializaion finished");
        return oRB;
    }

    private void initPropertyPolicy() {
        Domain domain = this.getORBDomain();
        Hashtable hashtable = new Hashtable();
        PropertyPolicyImpl.updatePropertyPolicies(Environment.getProperties(), "jacorb.policy.", hashtable, domain);
        Enumeration enumeration = hashtable.elements();
        Debug.output(32772, "found " + hashtable.size() + " policies");
        while (enumeration.hasMoreElements()) {
            PropertyPolicy propertyPolicy = (PropertyPolicy)enumeration.nextElement();
            try {
                domain.set_domain_policy(propertyPolicy);
            }
            catch (PolicyTypeAlreadyDefined policyTypeAlreadyDefined) {
                Debug.output(32769, " policy of type " + propertyPolicy.policy_type() + " already defined in local orb domain ");
            }
        }
        this._policyEditors = (PropertyPolicy)hashtable.get("PolicyEditor");
    }

    public synchronized void registerFrame(BrowserFrame browserFrame) {
        this._frames.put(browserFrame, browserFrame);
        if (!this.DomainBufferIsEmpty()) {
            browserFrame.enableDomainPasteMenuItem();
        }
        if (!this.MemberBufferIsEmpty()) {
            browserFrame.enableMemberPasteMenuItem();
        }
        if (!this.PolicyBufferIsEmpty()) {
            browserFrame.enablePolicyPasteMenuItem();
        }
    }

    public void setDomainBuffer(Domain domain) {
        java.lang.Object object = this._domainLock;
        synchronized (object) {
            boolean bl = false;
            if (this.DomainBufferIsEmpty()) {
                bl = true;
            }
            this._domainBuffer = domain;
            if (bl) {
                Enumeration enumeration = this._frames.keys();
                BrowserFrame browserFrame = null;
                while (enumeration.hasMoreElements()) {
                    browserFrame = (BrowserFrame)enumeration.nextElement();
                    browserFrame.enableDomainPasteMenuItem();
                }
            }
        }
    }

    public void setMemberBuffer(Object object, String string) {
        java.lang.Object object2 = this._memberLock;
        synchronized (object2) {
            boolean bl = false;
            if (this.MemberBufferIsEmpty()) {
                bl = true;
            }
            this._memberBuffer = object;
            this._memberNameBuffer = string;
            if (bl) {
                Enumeration enumeration = this._frames.keys();
                BrowserFrame browserFrame = null;
                while (enumeration.hasMoreElements()) {
                    browserFrame = (BrowserFrame)enumeration.nextElement();
                    browserFrame.enableMemberPasteMenuItem();
                }
            }
        }
    }

    public void setPolicyBuffer(Policy policy) {
        java.lang.Object object = this._policyLock;
        synchronized (object) {
            boolean bl = false;
            if (this.PolicyBufferIsEmpty()) {
                bl = true;
            }
            this._policyBuffer = policy;
            if (bl) {
                Enumeration enumeration = this._frames.keys();
                BrowserFrame browserFrame = null;
                while (enumeration.hasMoreElements()) {
                    browserFrame = (BrowserFrame)enumeration.nextElement();
                    browserFrame.enablePolicyPasteMenuItem();
                }
            }
        }
    }
}

