/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.giop;

import jacorb.orb.CDROutputStream;
import jacorb.orb.Connection;
import org.omg.GIOP.ReplyHeader;
import org.omg.GIOP.ReplyHeaderHelper;
import org.omg.GIOP.ReplyStatusType;
import org.omg.IOP.ServiceContext;

public class ReplyOutputStream
extends CDROutputStream {
    private ReplyHeader rep_hdr;

    ReplyOutputStream(Connection connection) {
        super(connection);
    }

    public ReplyOutputStream(Connection connection, ServiceContext[] serviceContextArray, int n, ReplyStatusType replyStatusType) {
        this(connection, serviceContextArray, n, replyStatusType, false);
    }

    public ReplyOutputStream(Connection connection, ServiceContext[] serviceContextArray, int n, ReplyStatusType replyStatusType, boolean bl) {
        super(connection);
        this.rep_hdr = new ReplyHeader(serviceContextArray, n, replyStatusType);
        if (bl) {
            this.header_stream = new CDROutputStream(this.connection);
        } else {
            this.writeHeader(this);
        }
    }

    public ServiceContext[] getServiceContexts() {
        return this.rep_hdr.service_context;
    }

    public int requestId() {
        return this.rep_hdr.request_id;
    }

    public void setServiceContexts(ServiceContext[] serviceContextArray) {
        if (serviceContextArray[serviceContextArray.length - 1].context_id != Integer.MAX_VALUE) {
            throw new Error("Last ServiceContext in array must be of type Integer.MAX_VALUE!");
        }
        this.rep_hdr.service_context = serviceContextArray;
        this.header_stream = new CDROutputStream(this.connection);
        this.writeHeader(this.header_stream);
        int n = this.header_stream.size() % 8;
        int n2 = n = n == 8 ? 0 : n;
        if (n > 0) {
            this.rep_hdr.service_context[serviceContextArray.length - 1].context_data = new byte[n];
            this.header_stream.reset();
            this.writeHeader(this.header_stream);
        }
    }

    private void writeHeader(CDROutputStream cDROutputStream) {
        cDROutputStream.writeGIOPMsgHeader((byte)1);
        ReplyHeaderHelper.write(cDROutputStream, this.rep_hdr);
    }
}

