/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.standardInterceptors;

import jacorb.orb.CDROutputStream;
import jacorb.orb.LocalityConstrainedObject;
import jacorb.orb.ORB;
import jacorb.util.Debug;
import jacorb.util.Environment;
import org.omg.IIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class SSLComponentInterceptor
extends LocalityConstrainedObject
implements IORInterceptor {
    private ORB orb = null;

    public SSLComponentInterceptor(ORB oRB) {
        this.orb = oRB;
    }

    public void establish_components(IORInfo iORInfo) {
        try {
            Version version = new Version(1, 1);
            SSL sSL = new SSL(Environment.supportedBySSL(), Environment.requiredBySSL(), (short)this.orb.getBasicAdapter().getSSLPort());
            if (!Environment.enforceSSL()) {
                sSL.target_supports = (short)(sSL.target_supports | 1);
            }
            CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
            cDROutputStream.beginEncapsulation();
            SSLHelper.write(cDROutputStream, sSL);
            cDROutputStream.endEncapsulation();
            TaggedComponent taggedComponent = new TaggedComponent(20, cDROutputStream.getBufferCopy());
            cDROutputStream.close();
            iORInfo.add_ior_component_to_profile(taggedComponent, 0);
        }
        catch (Exception exception) {
            Debug.output(0x10000001, exception);
        }
    }

    public String name() {
        return "SSLComponentCreator";
    }
}

