/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.util;

import java.util.StringTokenizer;
import org.omg.IIOP.Version;

public class CorbaLoc {
    private String keyString;
    private byte[] key;
    private String bodyString;
    public ObjectAddress[] objectAddressList;

    public CorbaLoc(String string) {
        this.parse(string);
    }

    public String body() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.bodyString);
        if (this.keyString != null) {
            stringBuffer.append("/" + this.keyString);
        }
        return stringBuffer.toString();
    }

    public void defaultKeyString(String string) {
        if (this.keyString != null) {
            throw new RuntimeException("KeyString not empty, cannot default to " + string);
        }
        this.keyString = string;
    }

    public byte[] getKey() {
        return this.key;
    }

    public String getKeyString() {
        return this.keyString;
    }

    private static byte hexValue(char c) {
        return (byte)(c >= 'a' ? 10 + c - 97 : (c >= 'A' ? 10 + c - 65 : c - 48));
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean legalChar(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == ';' || c == '/' || c == ':' || c == '?' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')';
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(new CorbaLoc(stringArray[n]).toString());
            ++n;
        }
    }

    private void parse(String string) {
        String string2;
        if (string == null || !string.startsWith("corbaloc:")) {
            throw new IllegalArgumentException("URL must start with 'corbaloc:'");
        }
        if (string.indexOf(47) == -1) {
            string2 = new String(string.substring(string.indexOf(58) + 1));
            this.keyString = null;
            this.key = new byte[0];
        } else {
            string2 = new String(string.substring(string.indexOf(58) + 1, string.indexOf(47)));
            this.keyString = string.substring(string.indexOf(47) + 1);
            this.key = this.parseKey(this.keyString);
        }
        if (string2.indexOf(44) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            this.objectAddressList = new ObjectAddress[stringTokenizer.countTokens()];
            int n = 0;
            while (n < this.objectAddressList.length) {
                this.objectAddressList[n] = this.parseObjectAddress(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            this.objectAddressList = new ObjectAddress[]{this.parseObjectAddress(string2)};
        }
        this.bodyString = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] parseKey(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (!CorbaLoc.legalChar(cArray[n2])) {
                if (cArray[n2] != '%') throw new IllegalArgumentException("URL character out of range: " + cArray[n2]);
                if (!CorbaLoc.isHex(cArray[n2 + 1]) || !CorbaLoc.isHex(cArray[n2 + 2])) throw new IllegalArgumentException("Illegal escape in URL character");
                n -= 2;
                n2 += 2;
            }
            ++n2;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (CorbaLoc.legalChar(cArray[n3])) {
                byArray[n4] = (byte)cArray[n3++];
            } else {
                byArray[n4] = (byte)(CorbaLoc.hexValue(cArray[n3 + 1]) << 4 | CorbaLoc.hexValue(cArray[n3 + 2]));
                n3 += 3;
            }
            ++n4;
        }
        return byArray;
    }

    public static String parseKey(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if (!CorbaLoc.legalChar((char)byArray[n])) {
                stringBuffer.append('%');
                stringBuffer.append(CorbaLoc.hexValue((char)(byArray[n] & 0xF0)));
                stringBuffer.append(CorbaLoc.hexValue((char)(byArray[n] & 0xF)));
            } else {
                stringBuffer.append((char)byArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private ObjectAddress parseObjectAddress(String string) {
        if (string.indexOf(58) == -1) {
            throw new IllegalArgumentException("Illegal object address format: " + string);
        }
        ObjectAddress objectAddress = new ObjectAddress();
        if (string.equals("rir:")) {
            objectAddress.protocol_identifier = "rir";
            return objectAddress;
        }
        if (string.indexOf(58) == 0 || string.startsWith("iiop:")) {
            String string2;
            String string3 = string.substring(string.indexOf(58) + 1);
            if (string3.length() == 0) {
                throw new IllegalArgumentException("Illegal IIOP protocol format in object address format: " + string);
            }
            if (string3.indexOf(64) != -1) {
                String string4 = string3.substring(0, string3.indexOf(64));
                if (string4.indexOf(46) != -1) {
                    try {
                        objectAddress.major = Integer.parseInt(string4.substring(0, string4.indexOf(46)));
                        objectAddress.minor = Integer.parseInt(string4.substring(string4.indexOf(46) + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Illegal version format for IIOP protocol in object address format: " + string);
                    }
                }
                string2 = string3.substring(string3.indexOf(64) + 1);
            } else {
                string2 = string3;
            }
            if (string2.indexOf(58) != -1) {
                try {
                    objectAddress.host = string2.substring(0, string2.indexOf(58));
                    objectAddress.port = Integer.parseInt(string2.substring(string2.indexOf(58) + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Illegal port number in IIOP object address format: " + string);
                }
            } else {
                objectAddress.host = string2;
            }
            return objectAddress;
        }
        throw new IllegalArgumentException("Illegal protocol in object address format: " + string);
    }

    public String toCorbaName(String string) {
        if (this.getKeyString() == null) {
            this.defaultKeyString("NameService");
        }
        if (string != null && string.length() > 0) {
            try {
                return "corbaname:" + this.body() + "#" + string;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return "corbaname:" + this.body();
    }

    public String toString() {
        return "corbaloc:" + this.body();
    }

    public static class ObjectAddress {
        public String protocol_identifier = "iiop";
        public int major = 1;
        public int minor = 0;
        public String host = "127.0.0.1";
        public int port = 2089;

        public Version getVersion() {
            return new Version((byte)this.major, (byte)this.minor);
        }
    }
}

