/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.util;

import jacorb.orb.ParsedIOR;
import jacorb.orb.util.CorbaLoc;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.omg.CORBA.ORB;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IOP.IOR;
import org.omg.SSLIOP.SSL;

public class PrintIOR {
    static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void dump(byte by) {
        System.out.print("" + hexDigit[by >> 4 & 0xF] + hexDigit[by & 0xF]);
    }

    public static void dump(int n) {
        System.out.print("" + hexDigit[n >> 28 & 0xF] + hexDigit[n >> 24 & 0xF] + hexDigit[n >> 20 & 0xF] + hexDigit[n >> 16 & 0xF] + hexDigit[n >> 12 & 0xF] + hexDigit[n >> 8 & 0xF] + hexDigit[n >> 4 & 0xF] + hexDigit[n & 0xF]);
    }

    public static void dump(short s) {
        System.out.print("" + hexDigit[s >> 12 & 0xF] + hexDigit[s >> 9 & 0xF] + hexDigit[s >> 4 & 0xF] + hexDigit[s & 0xF]);
    }

    public static void dump(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            PrintIOR.dump(byArray[n]);
            System.out.print(" ");
            ++n;
        }
    }

    public static void dump(byte[] byArray, boolean bl) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 16 == 0) {
                System.out.println();
            }
            char c = byArray[n2] > 31 && byArray[n2] < 127 ? (char)((char)byArray[n2]) : (char)' ';
            System.out.print(":" + hexDigit[byArray[n2] >> 4 & 0xF] + hexDigit[byArray[n2] & 0xF] + " " + c);
            ++n2;
        }
    }

    public static void dump(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            PrintIOR.dump(nArray[n]);
            System.out.print(" ");
            ++n;
        }
    }

    public static void dumpHex(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = (byArray[n] & 0xFF) / 16;
            int n3 = (byArray[n] & 0xFF) % 16;
            char c = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
            char c2 = (char)(n3 > 9 ? 65 + (n3 - 10) : 48 + n3);
            System.out.print(String.valueOf(c) + c2 + " ");
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        ORB oRB = ORB.init(stringArray, null);
        String string = null;
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.err.println("Usage: java PrintIOR [ ior_str | -f filename ]");
            System.exit(1);
        }
        if (stringArray[0].equals("-f")) {
            try {
                object = new BufferedReader(new FileReader(stringArray[1]), 2048);
                String string2 = ((BufferedReader)object).readLine();
                if (string2 != null) {
                    string = string2;
                    while (string2 != null) {
                        string2 = ((BufferedReader)object).readLine();
                        if (string2 == null) continue;
                        string = String.valueOf(string) + string2;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        } else {
            string = stringArray[0];
        }
        object = new ParsedIOR(string);
        PrintIOR.printIOR((ParsedIOR)object, oRB);
    }

    public static void printIOR(ParsedIOR parsedIOR, ORB oRB) {
        IOR iOR = parsedIOR.getIOR();
        System.out.println("------IOR components-----");
        System.out.println("TypeId\t:\t" + iOR.type_id);
        int n = 0;
        while (n < iOR.profiles.length) {
            System.out.print("Profile Id   :  ");
            if (iOR.profiles[n].tag == 0) {
                SSL sSL;
                System.out.println("TAG_INTERNET_IOP");
                ProfileBody_1_1 profileBody_1_1 = parsedIOR.getProfileBody();
                System.out.println("IIOP Version :  " + profileBody_1_1.iiop_version.major + "." + profileBody_1_1.iiop_version.minor);
                System.out.println("Host\t:\t" + profileBody_1_1.host);
                int n2 = profileBody_1_1.port;
                if (n2 < 0) {
                    n2 += 65536;
                }
                System.out.println("Port\t:\t" + n2);
                System.out.println("Object key (URL):      " + CorbaLoc.parseKey(parsedIOR.get_object_key()));
                System.out.print("Object key (hex):    0x");
                PrintIOR.dumpHex(parsedIOR.get_object_key());
                System.out.println();
                if (profileBody_1_1.iiop_version.minor == 1 && (sSL = ParsedIOR.getSSLTaggedComponent(profileBody_1_1)) != null) {
                    System.out.print("target_supports\t:\t");
                    PrintIOR.dump(sSL.target_supports);
                    System.out.println();
                    System.out.print("target_requires\t:\t");
                    PrintIOR.dump(sSL.target_requires);
                    System.out.println();
                    System.out.println("SSL Port\t:\t" + sSL.port);
                }
            } else {
                System.out.println("TAG_MULTIPLE_COMPONENTS");
            }
            ++n;
        }
        oRB.shutdown(true);
    }
}

