/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading;

import jacorb.trading.db.DatabaseMgr;
import jacorb.trading.db.OfferDatabase;
import jacorb.trading.db.TypeDatabase;
import jacorb.trading.db.simple.SimpleDatabaseMgr;
import jacorb.trading.impl.AdminImpl;
import jacorb.trading.impl.ImportAttrib;
import jacorb.trading.impl.LinkAttrib;
import jacorb.trading.impl.LinkImpl;
import jacorb.trading.impl.LookupImpl;
import jacorb.trading.impl.ProxyImpl;
import jacorb.trading.impl.RegisterImpl;
import jacorb.trading.impl.RepositoryImpl;
import jacorb.trading.impl.SupportAttrib;
import jacorb.trading.impl.TraderComp;
import jacorb.util.Environment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.FollowOption;
import org.omg.PortableServer.POAHelper;

public class TradingService {
    private static final String s_defaultDbpath = "db";
    private static ORB orb;

    protected TradingService() {
    }

    public TradingService(DatabaseMgr databaseMgr, String string) {
        block10: {
            java.lang.Object object;
            Repository repository = null;
            Object object2 = null;
            try {
                object2 = orb.resolve_initial_references("InterfaceRepository");
            }
            catch (InvalidName invalidName) {}
            try {
                object = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
                object.the_POAManager().activate();
                if (object2 != null) {
                    repository = RepositoryHelper.narrow(object2);
                }
            }
            catch (InvalidName invalidName) {
            }
            catch (SystemException systemException) {
            }
            catch (UserException userException) {}
            object = databaseMgr.getOfferDatabase();
            TypeDatabase typeDatabase = databaseMgr.getTypeDatabase();
            RepositoryImpl repositoryImpl = new RepositoryImpl(typeDatabase, repository);
            repositoryImpl._this_object(orb);
            SupportAttrib supportAttrib = new SupportAttrib();
            supportAttrib.setModifiableProperties(this.getProperty("jtrader.modifiable_properties", true));
            supportAttrib.setDynamicProperties(this.getProperty("jtrader.dynamic_properties", true));
            supportAttrib.setProxyOffers(this.getProperty("jtrader.proxy_offers", true));
            supportAttrib.setTypeRepos(repositoryImpl._this());
            ImportAttrib importAttrib = new ImportAttrib();
            importAttrib.setDefSearchCard(this.getProperty("jtrader.def_search_card", Integer.MAX_VALUE));
            importAttrib.setMaxSearchCard(this.getProperty("jtrader.max_search_card", Integer.MAX_VALUE));
            importAttrib.setDefMatchCard(this.getProperty("jtrader.def_match_card", Integer.MAX_VALUE));
            importAttrib.setMaxMatchCard(this.getProperty("jtrader.max_match_card", Integer.MAX_VALUE));
            importAttrib.setDefReturnCard(this.getProperty("jtrader.def_return_card", Integer.MAX_VALUE));
            importAttrib.setMaxReturnCard(this.getProperty("jtrader.max_return_card", Integer.MAX_VALUE));
            importAttrib.setMaxList(this.getProperty("jtrader.max_list", Integer.MAX_VALUE));
            importAttrib.setDefHopCount(this.getProperty("jtrader.def_hop_count", Integer.MAX_VALUE));
            importAttrib.setMaxHopCount(this.getProperty("jtrader.max_hop_count", Integer.MAX_VALUE));
            importAttrib.setDefFollowPolicy(this.getProperty("jtrader.def_follow_policy", FollowOption.always));
            importAttrib.setMaxFollowPolicy(this.getProperty("jtrader.max_follow_policy", FollowOption.always));
            LinkAttrib linkAttrib = new LinkAttrib();
            linkAttrib.setMaxLinkFollowPolicy(this.getProperty("jtrader.max_link_follow_policy", FollowOption.always));
            TraderComp traderComp = new TraderComp();
            RegisterImpl registerImpl = new RegisterImpl(traderComp, supportAttrib, (OfferDatabase)object, repository);
            registerImpl._this_object(orb);
            traderComp.setRegisterInterface(registerImpl._this());
            LinkImpl linkImpl = new LinkImpl(traderComp, supportAttrib, linkAttrib);
            linkImpl._this_object(orb);
            traderComp.setLinkInterface(linkImpl._this());
            LookupImpl lookupImpl = new LookupImpl(traderComp, supportAttrib, importAttrib, (OfferDatabase)object, linkImpl);
            lookupImpl._this_object(orb);
            traderComp.setLookupInterface(lookupImpl._this());
            byte[] byArray = orb.object_to_string(lookupImpl._this()).getBytes();
            AdminImpl adminImpl = new AdminImpl(traderComp, supportAttrib, importAttrib, linkAttrib, (OfferDatabase)object, byArray);
            adminImpl._this_object(orb);
            traderComp.setAdminInterface(adminImpl._this());
            ProxyImpl proxyImpl = new ProxyImpl(traderComp, supportAttrib, (OfferDatabase)object);
            proxyImpl._this_object(orb);
            traderComp.setProxyInterface(proxyImpl._this());
            if (string == null) break block10;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(orb.object_to_string(lookupImpl._this()));
                printWriter.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Unable to write IOR to file " + string);
                System.exit(1);
            }
        }
    }

    public static ORB getORB() {
        return orb;
    }

    private int getProperty(String string, int n) {
        int n2;
        block2: {
            String string2 = Environment.getProperty(string);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    private FollowOption getProperty(String string, FollowOption followOption) {
        int n;
        block2: {
            String string2 = Environment.getProperty(string);
            n = followOption.value();
            if (string2 == null) break block2;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {}
        }
        return FollowOption.from_int(n);
    }

    private boolean getProperty(String string, boolean bl) {
        boolean bl2;
        block2: {
            String string2 = Environment.getProperty(string);
            bl2 = bl;
            if (string2 == null) break block2;
            try {
                bl2 = Boolean.valueOf(string2);
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        File file;
        String string = null;
        String string2 = s_defaultDbpath;
        if (stringArray.length != 1 && stringArray.length != 3) {
            TradingService.usage();
        }
        string = stringArray[0];
        if (stringArray.length == 3) {
            if (stringArray[1].equals("-d")) {
                string2 = stringArray[2];
            } else {
                TradingService.usage();
            }
        }
        if (!(file = new File(string2)).exists()) {
            System.out.println("The directory " + string2 + " does not exist");
            System.exit(1);
        } else if (!file.isDirectory()) {
            System.out.println("The path " + string2 + " is not a directory");
            System.exit(1);
        }
        orb = ORB.init(stringArray, null);
        SimpleDatabaseMgr simpleDatabaseMgr = new SimpleDatabaseMgr(string2);
        new TradingService(simpleDatabaseMgr, string);
        orb.run();
        simpleDatabaseMgr.shutdown();
        System.exit(0);
    }

    protected static void usage() {
        System.err.println("Usage: jacorb.trading.TradingService <iorfile> [-d dbpath]");
        System.exit(1);
    }
}

