/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.client.offers;

import jacorb.trading.client.offers.ConstraintDialog;
import jacorb.trading.client.util.AnyUtil;
import jacorb.trading.client.util.ConfirmDialog;
import jacorb.trading.client.util.Constrain;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.IllegalOfferId;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.NotImplemented;
import org.omg.CosTrading.OfferIdIteratorHolder;
import org.omg.CosTrading.OfferIdSeqHolder;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPackage.NotProxyOfferId;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTrading.RegisterPackage.ProxyOfferId;
import org.omg.CosTrading.UnknownOfferId;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;

public class Offers
extends Frame
implements ActionListener,
ItemListener,
Runnable {
    private Choice m_view;
    private List m_offers;
    private TextArea m_description;
    private Button m_refresh;
    private Button m_withdraw;
    private Button m_withdrawConstraint;
    private Label m_status;
    private ConstraintDialog m_constraintDialog;
    private Admin m_admin;
    private Register m_register;
    private Proxy m_proxy;
    private static ORB s_orb;

    public Offers(Admin admin, Register register, Proxy proxy) {
        super("Service Offers");
        this.setFont(new Font("Helvetica", 0, 12));
        this.m_admin = admin;
        this.m_register = register;
        this.m_proxy = proxy;
        this.createContents();
        this.refreshOffers();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("refresh")) {
            this.refreshOffers();
        } else if (string.equals("withdrawConstraint")) {
            if (this.m_constraintDialog == null) {
                this.m_constraintDialog = new ConstraintDialog((Frame)this, this.m_register);
                this.m_constraintDialog.setActionCommand("refresh");
                this.m_constraintDialog.addActionListener(this);
            }
            this.clearStatus();
            ((Component)this.m_constraintDialog).setVisible(true);
        } else if (string.equals("withdraw")) {
            String string2 = this.m_offers.getSelectedItem();
            ConfirmDialog confirmDialog = new ConfirmDialog((Frame)this, "Remove offer '" + string2 + "'?");
            confirmDialog.setActionCommand("confirm");
            confirmDialog.addActionListener(this);
            this.clearStatus();
            ((Component)confirmDialog).setVisible(true);
        } else if (string.equals("confirm")) {
            this.removeOffer();
        }
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0, 0, 0));
        panel2.add(new Label("View", 0));
        this.m_view = new Choice();
        this.m_view.add("Offers");
        this.m_view.add("Proxy Offers");
        this.m_view.addItemListener(this);
        panel2.add(this.m_view);
        Constrain.constrain(panel, panel2, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 0, 5);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridBagLayout());
        Constrain.constrain(panel3, new Label("Offers", 0), 0, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_offers = new List(10, false);
        this.m_offers.addItemListener(this);
        Constrain.constrain(panel3, this.m_offers, 0, 1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, panel3, 0, 1, 1, 1, 1, 18, 0.25, 1.0, 5, 10, 5, 5);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridBagLayout());
        Constrain.constrain(panel4, new Label("Offer information", 0), 0, 0, 2, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_description = new TextArea(10, 40);
        this.m_description.setEditable(false);
        Constrain.constrain(panel4, this.m_description, 0, 1, 2, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, panel4, 1, 1, 1, 1, 1, 12, 0.75, 1.0, 5, 5, 5, 10);
        Panel panel5 = new Panel();
        panel5.setLayout(new FlowLayout());
        this.m_refresh = new Button("Refresh");
        this.m_refresh.setActionCommand("refresh");
        this.m_refresh.addActionListener(this);
        panel5.add(this.m_refresh);
        this.m_withdraw = new Button("Withdraw...");
        this.m_withdraw.setActionCommand("withdraw");
        this.m_withdraw.addActionListener(this);
        panel5.add(this.m_withdraw);
        this.m_withdrawConstraint = new Button("Withdraw using constraint...");
        this.m_withdrawConstraint.setActionCommand("withdrawConstraint");
        this.m_withdrawConstraint.addActionListener(this);
        panel5.add(this.m_withdrawConstraint);
        Constrain.constrain(panel, panel5, 0, 2, 2, 1, 0, 18, 0.0, 0.0, 5, 5, 0, 10);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 3, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 3, 10);
        this.add(panel);
    }

    protected void describe() {
        String string = this.m_offers.getSelectedItem();
        if (this.m_view.getSelectedItem().equals("Offers")) {
            this.describeOffer(string);
        } else {
            this.describeProxy(string);
        }
    }

    protected void describeOffer(String string) {
        try {
            OfferInfo offerInfo = this.m_register.describe(string);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("Type: " + offerInfo.type);
            printWriter.println();
            this.describeProperties(printWriter, offerInfo.properties);
            printWriter.println();
            printWriter.println("Reference:");
            String string2 = s_orb.object_to_string(offerInfo.reference);
            printWriter.println("  " + string2);
            printWriter.flush();
            this.m_description.setText(stringWriter.toString());
        }
        catch (IllegalOfferId illegalOfferId) {
            this.showStatus("Illegal offer ID '" + illegalOfferId.id + "'");
        }
        catch (UnknownOfferId unknownOfferId) {
            this.showStatus("Unknown offer ID '" + unknownOfferId.id + "'");
        }
        catch (ProxyOfferId proxyOfferId) {
            this.showStatus("Offer '" + proxyOfferId.id + "' is a proxy");
        }
    }

    protected void describeProperties(PrintWriter printWriter, Property[] propertyArray) {
        printWriter.println("Properties:");
        int n = 0;
        while (n < propertyArray.length) {
            printWriter.print("  " + propertyArray[n].name + " = ");
            TypeCode typeCode = propertyArray[n].value.type();
            if (typeCode.equal(DynamicPropHelper.type())) {
                printWriter.println("<Dynamic>");
                DynamicProp dynamicProp = DynamicPropHelper.extract(propertyArray[n].value);
                printWriter.print("    eval_if = ");
                String string = s_orb.object_to_string(dynamicProp.eval_if);
                printWriter.println(string);
                printWriter.print("    returned_type = ");
                AnyUtil.print(printWriter, dynamicProp.returned_type);
                printWriter.println();
                printWriter.print("    extra_info = ");
                AnyUtil.print(s_orb, printWriter, dynamicProp.extra_info);
                printWriter.println();
            } else {
                AnyUtil.print(s_orb, printWriter, propertyArray[n].value);
                printWriter.println();
            }
            ++n;
        }
    }

    protected void describeProxy(String string) {
        try {
            ProxyInfo proxyInfo = this.m_proxy.describe_proxy(string);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("Type: " + proxyInfo.type);
            printWriter.println();
            this.describeProperties(printWriter, proxyInfo.properties);
            printWriter.println();
            printWriter.println("Target:");
            String string2 = s_orb.object_to_string(proxyInfo.target);
            printWriter.println("  " + string2);
            printWriter.println();
            printWriter.println("If match all: " + proxyInfo.if_match_all);
            printWriter.println();
            printWriter.println("Recipe:");
            printWriter.println("  " + proxyInfo.recipe);
            printWriter.println();
            printWriter.println("Policies to pass on:");
            int n = 0;
            while (n < proxyInfo.policies_to_pass_on.length) {
                printWriter.print("  " + proxyInfo.policies_to_pass_on[n].name + " = ");
                AnyUtil.print(s_orb, printWriter, proxyInfo.policies_to_pass_on[n].value);
                printWriter.println();
                ++n;
            }
            printWriter.flush();
            this.m_description.setText(stringWriter.toString());
        }
        catch (IllegalOfferId illegalOfferId) {
            this.showStatus("Illegal offer ID '" + illegalOfferId.id + "'");
        }
        catch (UnknownOfferId unknownOfferId) {
            this.showStatus("Unknown offer ID '" + unknownOfferId.id + "'");
        }
        catch (NotProxyOfferId notProxyOfferId) {
            this.showStatus("Offer '" + notProxyOfferId.id + "' is not a proxy");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.m_view) {
            this.refreshOffers();
        } else if (itemEvent.getItemSelectable() == this.m_offers) {
            this.updateButtons();
            this.clearStatus();
            if (itemEvent.getStateChange() == 1) {
                this.describe();
            }
        }
    }

    public static void main(String[] stringArray) {
        java.lang.Object object;
        s_orb = ORB.init(stringArray, null);
        Admin admin = null;
        Register register = null;
        Proxy proxy = null;
        try {
            object = s_orb.resolve_initial_references("TradingService");
            if (object == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow((Object)object);
            admin = lookup.admin_if();
            register = lookup.register_if();
            proxy = lookup.proxy_if();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        object = new Offers(admin, register, proxy);
        ((Window)object).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
                System.exit(0);
            }
        });
        ((Window)object).pack();
        ((Component)object).setVisible(true);
    }

    protected void refreshOffers() {
        new Thread(this).start();
    }

    protected void removeOffer() {
        try {
            String string = this.m_offers.getSelectedItem();
            if (this.m_view.getSelectedItem().equals("Offers")) {
                this.m_register.withdraw(string);
            } else {
                this.m_proxy.withdraw_proxy(string);
            }
            this.m_offers.remove(string);
            this.m_description.setText("");
            this.clearStatus();
            this.updateButtons();
        }
        catch (IllegalOfferId illegalOfferId) {
            this.showStatus("Illegal offer ID '" + illegalOfferId.id + "'");
        }
        catch (UnknownOfferId unknownOfferId) {
            this.showStatus("Unknown offer ID '" + unknownOfferId.id + "'");
        }
        catch (ProxyOfferId proxyOfferId) {
            this.showStatus("Offer '" + proxyOfferId.id + "' is a proxy");
        }
        catch (NotProxyOfferId notProxyOfferId) {
            this.showStatus("Offer '" + notProxyOfferId.id + "' is not a proxy");
        }
    }

    public void run() {
        this.showStatus("Refreshing offers...");
        this.m_offers.removeAll();
        this.m_description.setText("");
        this.updateButtons();
        try {
            OfferIdSeqHolder offerIdSeqHolder = new OfferIdSeqHolder();
            OfferIdIteratorHolder offerIdIteratorHolder = new OfferIdIteratorHolder();
            if (this.m_view.getSelectedItem().equals("Offers")) {
                this.m_admin.list_offers(100, offerIdSeqHolder, offerIdIteratorHolder);
            } else {
                this.m_admin.list_proxies(100, offerIdSeqHolder, offerIdIteratorHolder);
            }
            int n = offerIdSeqHolder.value.length;
            this.showStatus("Received " + n + " offers...");
            int n2 = 0;
            while (n2 < offerIdSeqHolder.value.length) {
                this.m_offers.add(offerIdSeqHolder.value[n2]);
                ++n2;
            }
            if (offerIdIteratorHolder.value != null) {
                boolean bl;
                OfferIdSeqHolder offerIdSeqHolder2 = new OfferIdSeqHolder();
                do {
                    bl = offerIdIteratorHolder.value.next_n(100, offerIdSeqHolder2);
                    this.showStatus("Received " + (n += offerIdSeqHolder2.value.length) + " offers...");
                    int n3 = 0;
                    while (n3 < offerIdSeqHolder2.value.length) {
                        this.m_offers.add(offerIdSeqHolder2.value[n3]);
                        ++n3;
                    }
                } while (bl);
                offerIdIteratorHolder.value.destroy();
            }
        }
        catch (NotImplemented notImplemented) {
            this.showStatus("Admin::list_offers not implemented");
        }
    }

    protected void showStatus(String string) {
        this.m_status.setText(string);
    }

    protected void updateButtons() {
        if (this.m_offers.getSelectedIndex() < 0) {
            this.m_withdraw.setEnabled(false);
        } else {
            this.m_withdraw.setEnabled(true);
        }
        if (this.m_view.getSelectedItem().equals("Offers")) {
            this.m_withdrawConstraint.setEnabled(true);
        } else {
            this.m_withdrawConstraint.setEnabled(false);
        }
    }

    protected static void usage() {
        System.out.println("Usage: Offers iorfile");
        System.exit(1);
    }
}

