/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.ExprNode;
import jacorb.trading.constraint.MissingPropertyException;
import jacorb.trading.constraint.PropertySource;
import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueType;
import java.io.PrintStream;

public class AddNode
extends ExprNode {
    private ExprNode m_left;
    private ExprNode m_right;

    private AddNode() {
    }

    public AddNode(ExprNode exprNode, ExprNode exprNode2) {
        this.m_left = exprNode;
        this.m_right = exprNode2;
        int n = ValueType.promote(exprNode.getType().getId(), exprNode2.getType().getId());
        this.setType(new ValueType(n));
    }

    public Value evaluate(PropertySource propertySource) throws MissingPropertyException {
        Value value = null;
        int n = this.getType().getId();
        Value value2 = this.m_left.evaluate(propertySource);
        Value value3 = value2.convert(n);
        value2 = this.m_right.evaluate(propertySource);
        Value value4 = value2.convert(n);
        value = value3.plus(value4);
        return value;
    }

    public void print(PrintStream printStream) {
        printStream.println("AddNode: type = " + this.getType());
        printStream.println("Left node:");
        this.m_left.print(printStream);
        printStream.println("Right node:");
        this.m_right.print(printStream);
    }
}

