/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueFactory;

public class CharValue
implements Value {
    private Character m_value;

    public CharValue() {
        this('\u0000');
    }

    public CharValue(char c) {
        this.m_value = new Character(c);
    }

    public CharValue(Object object) {
        this.m_value = (Character)object;
    }

    public Value convert(int n) {
        Value value = null;
        if (n == 7) {
            value = new CharValue(this.m_value);
        } else if (n == 8) {
            char[] cArray = new char[]{this.m_value.charValue()};
            String string = new String(cArray);
            value = ValueFactory.createString(string);
        } else {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public Value divide(Value value) {
        throw new ArithmeticException();
    }

    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 7) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    public int getTypeId() {
        return 7;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    public boolean greaterThanEqual(Value value) {
        return this.lessThan(value) ^ true;
    }

    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 7) {
            throw new IllegalArgumentException();
        }
        Character c = (Character)value.getValue();
        bl = this.m_value.charValue() < c.charValue();
        return bl;
    }

    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    public Value minus(Value value) {
        throw new ArithmeticException();
    }

    public Value multiply(Value value) {
        throw new ArithmeticException();
    }

    public Value negate() {
        throw new ArithmeticException();
    }

    public Value plus(Value value) {
        throw new ArithmeticException();
    }

    public void setValue(Object object) {
        this.m_value = (Character)object;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

