/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.Expression;
import jacorb.trading.constraint.Lex;
import jacorb.trading.constraint.ParseException;
import jacorb.trading.constraint.PropertySchema;
import jacorb.trading.constraint.PropertySource;
import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueType;
import java.io.StringReader;

public class Constraint {
    private PropertySchema m_schema;
    private Expression m_expr;
    private String m_constraint;

    private Constraint() {
    }

    public Constraint(PropertySchema propertySchema) {
        this.m_schema = propertySchema;
    }

    public boolean evaluate(PropertySource propertySource) {
        boolean bl = false;
        Value value = this.m_expr.evaluate(propertySource);
        if (value != null) {
            Boolean bl2 = (Boolean)value.getValue();
            bl = bl2;
        }
        return bl;
    }

    public String getConstraint() {
        return this.m_constraint;
    }

    public void parse(String string) throws ParseException {
        if (string.length() == 0) {
            string = "TRUE";
        }
        StringReader stringReader = new StringReader(string);
        Lex lex = new Lex(stringReader);
        this.m_constraint = string;
        this.m_expr = new Expression(this.m_schema);
        ValueType valueType = this.m_expr.parse(lex);
        if (!ValueType.isCompatible(valueType.getId(), 0) || valueType.isSequence()) {
            throw new ParseException("constraint expression must be boolean");
        }
    }
}

