/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.ExprNode;
import jacorb.trading.constraint.MissingPropertyException;
import jacorb.trading.constraint.PropertyNode;
import jacorb.trading.constraint.PropertySource;
import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueFactory;
import jacorb.trading.constraint.ValueType;
import java.io.PrintStream;

public class ExistNode
extends ExprNode {
    private ExprNode m_child;

    private ExistNode() {
    }

    public ExistNode(ExprNode exprNode) {
        this.m_child = exprNode;
        this.setType(new ValueType(0));
    }

    public Value evaluate(PropertySource propertySource) throws MissingPropertyException {
        Value value = null;
        PropertyNode propertyNode = (PropertyNode)this.m_child;
        value = ValueFactory.createBoolean(propertyNode.exists(propertySource));
        return value;
    }

    public void print(PrintStream printStream) {
        printStream.println("ExistNode: type = " + this.getType());
        printStream.println("Child node:");
        this.m_child.print(printStream);
    }
}

