/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueFactory;

public class FloatValue
implements Value {
    private Float m_value;

    public FloatValue() {
        this(0.0f);
    }

    public FloatValue(float f) {
        this.m_value = new Float(f);
    }

    public FloatValue(Object object) {
        this.m_value = (Float)object;
    }

    public Value convert(int n) {
        Value value = null;
        switch (n) {
            case 5: {
                value = new FloatValue(this.m_value);
                break;
            }
            case 6: {
                value = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    public Value divide(Value value) {
        FloatValue floatValue = null;
        if (value.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)value.getValue();
        floatValue = new FloatValue(this.m_value.floatValue() / f.floatValue());
        return floatValue;
    }

    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    public int getTypeId() {
        return 5;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    public boolean greaterThanEqual(Value value) {
        return this.lessThan(value) ^ true;
    }

    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)value.getValue();
        bl = this.m_value.floatValue() < f.floatValue();
        return bl;
    }

    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    public Value minus(Value value) {
        FloatValue floatValue = null;
        if (value.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)value.getValue();
        floatValue = new FloatValue(this.m_value.floatValue() - f.floatValue());
        return floatValue;
    }

    public Value multiply(Value value) {
        FloatValue floatValue = null;
        if (value.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)value.getValue();
        floatValue = new FloatValue(this.m_value.floatValue() * f.floatValue());
        return floatValue;
    }

    public Value negate() {
        FloatValue floatValue = null;
        floatValue = new FloatValue(-1.0f * this.m_value.floatValue());
        return floatValue;
    }

    public Value plus(Value value) {
        FloatValue floatValue = null;
        if (value.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)value.getValue();
        floatValue = new FloatValue(this.m_value.floatValue() + f.floatValue());
        return floatValue;
    }

    public void setValue(Object object) {
        this.m_value = (Float)object;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

