/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.Expression;
import jacorb.trading.constraint.Lex;
import jacorb.trading.constraint.ParseException;
import jacorb.trading.constraint.PropertySchema;
import jacorb.trading.constraint.PropertySource;
import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueType;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class Preference {
    private PropertySchema m_schema;
    private Expression m_expr;
    private ValueType m_exprType;
    private int m_prefType = 29;

    private Preference() {
    }

    public Preference(PropertySchema propertySchema) {
        this.m_schema = propertySchema;
    }

    public Vector order(Vector vector) {
        Vector vector2 = null;
        switch (this.m_prefType) {
            case 25: {
                vector2 = this.orderMin(vector);
                break;
            }
            case 26: {
                vector2 = this.orderMax(vector);
                break;
            }
            case 27: {
                vector2 = this.orderWith(vector);
                break;
            }
            case 28: {
                vector2 = this.orderRandom(vector);
                break;
            }
            case 29: {
                vector2 = this.orderFirst(vector);
                break;
            }
        }
        return vector2;
    }

    protected Vector orderFirst(Vector vector) {
        return vector;
    }

    protected Vector orderMax(Vector vector) {
        Object object;
        Vector<PropertySource> vector2 = new Vector<PropertySource>();
        Vector vector3 = (Vector)vector.clone();
        Vector<SourceValue> vector4 = new Vector<SourceValue>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (PropertySource)enumeration.nextElement();
            Value value = this.m_expr.evaluate((PropertySource)object);
            if (value == null) continue;
            Enumeration enumeration2 = vector4.elements();
            int n = 0;
            while (enumeration2.hasMoreElements()) {
                SourceValue sourceValue = (SourceValue)enumeration2.nextElement();
                if (value.greaterThan(sourceValue.value)) break;
                ++n;
            }
            vector4.insertElementAt(new SourceValue((PropertySource)object, value), n);
            vector3.removeElement(object);
        }
        enumeration = vector4.elements();
        while (enumeration.hasMoreElements()) {
            object = (SourceValue)enumeration.nextElement();
            vector2.addElement(((SourceValue)object).source);
        }
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement((PropertySource)enumeration.nextElement());
        }
        return vector2;
    }

    protected Vector orderMin(Vector vector) {
        Object object;
        Vector<PropertySource> vector2 = new Vector<PropertySource>();
        Vector vector3 = (Vector)vector.clone();
        Vector<SourceValue> vector4 = new Vector<SourceValue>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (PropertySource)enumeration.nextElement();
            Value value = this.m_expr.evaluate((PropertySource)object);
            if (value == null) continue;
            Enumeration enumeration2 = vector4.elements();
            int n = 0;
            while (enumeration2.hasMoreElements()) {
                SourceValue sourceValue = (SourceValue)enumeration2.nextElement();
                if (value.lessThan(sourceValue.value)) break;
                ++n;
            }
            vector4.insertElementAt(new SourceValue((PropertySource)object, value), n);
            vector3.removeElement(object);
        }
        enumeration = vector4.elements();
        while (enumeration.hasMoreElements()) {
            object = (SourceValue)enumeration.nextElement();
            vector2.addElement(((SourceValue)object).source);
        }
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement((PropertySource)enumeration.nextElement());
        }
        return vector2;
    }

    protected Vector orderRandom(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        int n = vector.size();
        Object[] objectArray = new PropertySource[n];
        vector.copyInto(objectArray);
        Random random = new Random();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.abs(random.nextInt()) % n;
            if (objectArray[n3] == null) continue;
            vector2.addElement(objectArray[n3]);
            objectArray[n3] = null;
            ++n2;
        }
        return vector2;
    }

    protected Vector orderWith(Vector vector) {
        Vector<PropertySource> vector2 = new Vector<PropertySource>();
        Vector vector3 = (Vector)vector.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Boolean bl;
            PropertySource propertySource = (PropertySource)enumeration.nextElement();
            Value value = this.m_expr.evaluate(propertySource);
            if (value == null || !(bl = (Boolean)value.getValue()).booleanValue()) continue;
            vector2.addElement(propertySource);
            vector3.removeElement(propertySource);
        }
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement((PropertySource)enumeration.nextElement());
        }
        return vector2;
    }

    public void parse(String string) throws ParseException {
        StringReader stringReader = new StringReader(string);
        Lex lex = new Lex(stringReader);
        this.m_prefType = lex.getToken();
        switch (this.m_prefType) {
            case 25: 
            case 26: {
                this.m_expr = new Expression(this.m_schema);
                lex.nextToken();
                this.m_exprType = this.m_expr.parse(lex);
                if (this.m_exprType.isNumber() && !this.m_exprType.isSequence()) break;
                throw new ParseException("min/max preference expression must be numeric");
            }
            case 27: {
                this.m_expr = new Expression(this.m_schema);
                lex.nextToken();
                this.m_exprType = this.m_expr.parse(lex);
                if (ValueType.isCompatible(this.m_exprType.getId(), 0) && !this.m_exprType.isSequence()) break;
                throw new ParseException("with preference expression must be boolean");
            }
            case 1: {
                this.m_prefType = 29;
                break;
            }
            default: {
                throw new ParseException("invalid preference expression");
            }
            case 28: 
            case 29: 
        }
    }

    protected class SourceValue {
        public PropertySource source;
        public Value value;

        public SourceValue(PropertySource propertySource, Value value) {
            this.source = propertySource;
            this.value = value;
        }
    }
}

