/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

import jacorb.trading.constraint.ExprNode;
import jacorb.trading.constraint.MissingPropertyException;
import jacorb.trading.constraint.PropertySource;
import jacorb.trading.constraint.Value;
import jacorb.trading.constraint.ValueType;
import java.io.PrintStream;

public class PropertyNode
extends ExprNode {
    private String m_name;

    private PropertyNode() {
    }

    public PropertyNode(String string, ValueType valueType) {
        this.m_name = string;
        this.setType(valueType);
    }

    public Value evaluate(PropertySource propertySource) throws MissingPropertyException {
        Value value = propertySource.getValue(this.m_name);
        if (value == null) {
            throw new MissingPropertyException(this.m_name);
        }
        return value;
    }

    public boolean exists(PropertySource propertySource) {
        boolean bl = propertySource.exists(this.m_name) && propertySource.getValue(this.m_name) != null;
        return bl;
    }

    public boolean inSequence(Value value, PropertySource propertySource) {
        boolean bl = false;
        int n = ValueType.promote(this.getType().getId(), value.getTypeId());
        Value value2 = value.convert(n);
        Value[] valueArray = propertySource.getSequenceValues(this.m_name);
        int n2 = 0;
        while (n2 < valueArray.length) {
            Value value3 = valueArray[n2].convert(n);
            if (value2.equals(value3)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void print(PrintStream printStream) {
        printStream.println("PropertyNode: name = " + this.m_name + " type = " + this.getType());
    }
}

