/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.db.simple.offers;

import jacorb.trading.db.OfferDatabase;
import jacorb.trading.db.simple.offers.AnyValue;
import jacorb.trading.db.simple.offers.OfferList;
import jacorb.trading.util.PropUtil;
import jacorb.trading.util.RWLock;
import jacorb.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;

public class OfferDatabaseImpl
implements OfferDatabase {
    private File m_dirPath;
    private Hashtable m_offerLists;
    private Hashtable m_offerIndex;
    private File m_indexFile;
    private int m_counter;
    private boolean m_indexDirty = false;
    private RWLock m_lock;
    private static String LIST_NAME = "OFR_";
    private static String LIST_EXT = ".dat";
    private static String INDEX_FILE = "offeridx.dat";

    private OfferDatabaseImpl() {
    }

    public OfferDatabaseImpl(String string) {
        this.m_dirPath = new File(string);
        this.m_indexFile = new File(string, INDEX_FILE);
        if (this.m_indexFile.exists()) {
            this.readIndex();
        } else {
            this.m_offerIndex = new Hashtable();
            this.m_counter = 0;
            this.writeIndex();
        }
        this.m_offerLists = new Hashtable();
        this.m_lock = new RWLock();
    }

    public void begin(int n) {
        if (n == 0) {
            this.m_lock.acquireRead();
        } else if (n == 1) {
            this.m_lock.acquireWrite();
        } else {
            throw new RuntimeException("Invalid lock mode");
        }
    }

    public String create(String string, Object object, Property[] propertyArray) {
        OfferList offerList = this.getList(string);
        if (offerList == null) {
            offerList = this.createList(string);
        }
        return offerList.create(object, propertyArray);
    }

    protected OfferList createList(String string) {
        OfferList offerList = new OfferList(string);
        this.m_offerLists.put(string, offerList);
        ++this.m_counter;
        this.m_offerIndex.put(string, new Integer(this.m_counter));
        this.m_indexDirty = true;
        return offerList;
    }

    public String createProxy(Lookup lookup, String string, Property[] propertyArray, boolean bl, String string2, Policy[] policyArray) {
        OfferList offerList = this.getList(string);
        if (offerList == null) {
            offerList = this.createList(string);
        }
        return offerList.createProxy(lookup, propertyArray, bl, string2, policyArray);
    }

    public OfferInfo describe(String string) {
        OfferInfo offerInfo = null;
        OfferList offerList = this.getList(this.whichService(string));
        if (offerList != null) {
            offerInfo = offerList.describe(string);
        }
        return offerInfo;
    }

    public ProxyInfo describeProxy(String string) {
        ProxyInfo proxyInfo = null;
        OfferList offerList = this.getList(this.whichService(string));
        if (offerList != null) {
            proxyInfo = offerList.describeProxy(string);
        }
        return proxyInfo;
    }

    public void end() {
        Enumeration enumeration = this.m_offerLists.elements();
        while (enumeration.hasMoreElements()) {
            OfferList offerList = (OfferList)enumeration.nextElement();
            if (!offerList.getDirty()) continue;
            this.writeList(offerList);
        }
        if (this.m_indexDirty) {
            this.writeIndex();
            this.m_indexDirty = false;
        }
        this.m_lock.release();
    }

    public boolean exists(String string) {
        boolean bl = false;
        OfferList offerList = this.getList(this.whichService(string));
        if (offerList != null) {
            bl = offerList.exists(string);
        }
        return bl;
    }

    protected synchronized OfferList getList(String string) {
        OfferList offerList = null;
        offerList = (OfferList)this.m_offerLists.get(string);
        if (offerList == null && (offerList = this.readList(string)) != null) {
            this.m_offerLists.put(string, offerList);
        }
        return offerList;
    }

    protected File getListFile(String string) {
        File file = null;
        Integer n = (Integer)this.m_offerIndex.get(string);
        if (n != null) {
            file = new File(this.m_dirPath, String.valueOf(LIST_NAME) + n + LIST_EXT);
        }
        return file;
    }

    public String[] getOfferIds(String string) {
        String[] stringArray = null;
        OfferList offerList = this.getList(string);
        if (offerList != null) {
            stringArray = offerList.getOfferIds();
        }
        return stringArray;
    }

    public Hashtable getOffers(String string) {
        Hashtable hashtable = null;
        OfferList offerList = this.getList(string);
        if (offerList != null) {
            hashtable = offerList.getOffers();
        }
        return hashtable;
    }

    public String[] getProxyOfferIds(String string) {
        String[] stringArray = null;
        OfferList offerList = this.getList(string);
        if (offerList != null) {
            stringArray = offerList.getProxyOfferIds();
        }
        return stringArray;
    }

    public Hashtable getProxyOffers(String string) {
        Hashtable hashtable = null;
        OfferList offerList = this.getList(string);
        if (offerList != null) {
            hashtable = offerList.getProxyOffers();
        }
        return hashtable;
    }

    public boolean isProxy(String string) {
        boolean bl = false;
        OfferList offerList = this.getList(this.whichService(string));
        if (offerList != null) {
            bl = offerList.isProxy(string);
        }
        return bl;
    }

    public boolean isTypeSupported(Any any) {
        boolean bl;
        if (PropUtil.isDynamicProperty(any.type())) {
            DynamicProp dynamicProp = DynamicPropHelper.extract(any);
            bl = AnyValue.isTypeSupported(dynamicProp.extra_info.type());
        } else {
            bl = AnyValue.isTypeSupported(any.type());
        }
        return bl;
    }

    public void modify(String string, Property[] propertyArray) {
        OfferList offerList = this.getList(this.whichService(string));
        if (offerList != null) {
            offerList.modify(string, propertyArray);
        }
    }

    protected void readIndex() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.m_indexFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Integer n = (Integer)objectInputStream.readObject();
            this.m_counter = n;
            this.m_offerIndex = (Hashtable)objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.getMessage());
        }
    }

    protected OfferList readList(String string) {
        OfferList offerList = null;
        File file = this.getListFile(string);
        if (file != null && file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                offerList = (OfferList)objectInputStream.readObject();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
        }
        return offerList;
    }

    public void remove(String string) {
        OfferList offerList = this.getList(this.whichService(string));
        if (offerList != null) {
            offerList.remove(string);
        }
    }

    public void removeProxy(String string) {
        OfferList offerList = this.getList(this.whichService(string));
        if (offerList != null) {
            offerList.removeProxy(string);
        }
    }

    public boolean validateOfferId(String string) {
        return OfferList.validateOfferId(string);
    }

    public String whichService(String string) {
        return OfferList.whichService(string);
    }

    protected void writeIndex() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.m_indexFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(new Integer(this.m_counter));
            objectOutputStream.writeObject(this.m_offerIndex);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    protected void writeList(OfferList offerList) {
        try {
            File file = this.getListFile(offerList.getServiceType());
            if (file == null) {
                throw new RuntimeException("listFile should not be null!");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(offerList);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Debug.output(1, iOException);
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

