/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.impl;

import jacorb.trading.impl.SourceAdapter;
import jacorb.trading.util.PropUtil;
import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosTrading.Property;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;

public class Recipe {
    private Recipe() {
    }

    protected static boolean checkPropertyType(TypeCode typeCode) {
        boolean bl = false;
        TCKind tCKind = typeCode.kind();
        switch (tCKind.value()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected static String convertValue(Any any) {
        String string = "<unknown>";
        TCKind tCKind = any.type().kind();
        try {
            switch (tCKind.value()) {
                case 2: {
                    short s = any.extract_short();
                    string = String.valueOf(s);
                    break;
                }
                case 3: {
                    int n = any.extract_long();
                    string = String.valueOf(n);
                    break;
                }
                case 4: {
                    short s = any.extract_ushort();
                    string = String.valueOf(s);
                    break;
                }
                case 5: {
                    long l = any.extract_ulong();
                    string = String.valueOf(l);
                    break;
                }
                case 6: {
                    float f = any.extract_float();
                    string = String.valueOf(f);
                    break;
                }
                case 7: {
                    double d = any.extract_double();
                    string = String.valueOf(d);
                    break;
                }
                case 8: {
                    boolean bl = any.extract_boolean();
                    string = String.valueOf(bl ? "TRUE" : "FALSE");
                    break;
                }
                case 9: {
                    char c = any.extract_char();
                    string = "'" + c + "'";
                    break;
                }
                case 18: {
                    String string2 = any.extract_string();
                    string = "'" + string2 + "'";
                    break;
                }
                default: {
                    return string;
                }
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            bAD_OPERATION.printStackTrace();
        }
        return string;
    }

    public static String rewrite(String string, SourceAdapter sourceAdapter, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '$': {
                    if (bl) {
                        stringBuffer.append('$');
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '*': {
                    if (bl) {
                        bl = false;
                        stringBuffer.append(string2);
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '(': {
                    if (bl) {
                        int n3 = string.indexOf(41, n);
                        String string3 = string.substring(n + 1, n3);
                        Any any = sourceAdapter.getPropertyValue(string3);
                        if (any == null) {
                            return null;
                        }
                        stringBuffer.append(Recipe.convertValue(any));
                        n = n3;
                        bl = false;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean validate(String string, Property[] propertyArray) {
        boolean bl = true;
        int n = 0;
        int n2 = string.length();
        Hashtable<String, Any> hashtable = new Hashtable<String, Any>();
        int n3 = 0;
        while (n3 < propertyArray.length) {
            hashtable.put(propertyArray[n3].name, propertyArray[n3].value);
            ++n3;
        }
        boolean bl2 = false;
        while (n < n2 && bl) {
            char c = string.charAt(n);
            switch (c) {
                case '$': {
                    if (bl2) {
                        bl2 = false;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case '*': {
                    if (!bl2) break;
                    bl2 = false;
                    break;
                }
                case '(': {
                    if (!bl2) break;
                    int n4 = string.indexOf(41, n);
                    if (n4 < 0) {
                        bl = false;
                    } else {
                        String string2 = string.substring(n + 1, n4);
                        if (!hashtable.containsKey(string2)) {
                            bl = false;
                        } else {
                            Any any = (Any)hashtable.get(string2);
                            TypeCode typeCode = any.type();
                            if (PropUtil.isDynamicProperty(typeCode)) {
                                DynamicProp dynamicProp = DynamicPropHelper.extract(any);
                                typeCode = dynamicProp.returned_type;
                            }
                            bl = Recipe.checkPropertyType(typeCode);
                        }
                        n = n4;
                    }
                    bl2 = false;
                    break;
                }
            }
            ++n;
        }
        if (bl2) {
            bl = false;
        }
        return bl;
    }
}

