/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.util;

import jacorb.trading.util.TimerListNode;
import jacorb.util.Debug;
import java.util.Hashtable;

public class TimeoutThread
extends Thread {
    private int timeout = 0;
    private TimerListNode last = null;
    private TimerListNode first = null;
    private Hashtable current_nodes = null;

    public TimeoutThread(int n) {
        this.timeout = n;
        this.first = this.last = new TimerListNode();
        this.current_nodes = new Hashtable();
        this.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.first = this.first.getNext();
                    if (this.first.wakeup_time <= System.currentTimeMillis()) {
                        this.first.doInterrupt();
                        continue;
                    }
                    Thread.sleep(Math.abs(this.first.wakeup_time - System.currentTimeMillis()));
                    this.first.doInterrupt();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                continue;
            }
            break;
        }
    }

    public synchronized void setTimeout(Thread thread) {
        TimerListNode timerListNode = new TimerListNode(thread, (long)this.timeout + System.currentTimeMillis());
        this.last.setNext(timerListNode);
        this.last = timerListNode;
        this.current_nodes.put(thread, timerListNode);
    }

    public void stopTimer(Thread thread) {
        Debug.output(2, "Timer.stop for interruptee " + thread.toString());
        TimerListNode timerListNode = (TimerListNode)this.current_nodes.get(thread);
        timerListNode.stopTimer();
    }
}

