/*
 * Decompiled with CFR 0.152.
 */
package jacorb.transaction;

import jacorb.transaction.Sleeper;
import jacorb.transaction.TransactionService;
import java.util.Vector;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.ControlOperations;
import org.omg.CosTransactions.ControlPOATie;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.CoordinatorOperations;
import org.omg.CosTransactions.CoordinatorPOATie;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TerminatorOperations;
import org.omg.CosTransactions.TerminatorPOATie;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class CoordinatorImpl
implements Sleeper,
CoordinatorOperations,
ControlOperations,
TerminatorOperations {
    private Terminator term_ref;
    private TerminatorPOATie term_skel;
    private Coordinator coord_ref;
    private CoordinatorPOATie coord_skel;
    private Control contr_ref;
    private ControlPOATie contr_skel;
    private int transaction_id;
    private int hash_code;
    private int status;
    private String stat_semaphore;
    private Vector resources;
    private Vector votes;
    private Vector syncs;
    private POA poa;

    CoordinatorImpl(POA pOA, int n, int n2, int n3) {
        this.transaction_id = n;
        this.hash_code = n2;
        this.poa = pOA;
        this.stat_semaphore = new String("sss");
        this.resources = new Vector();
        this.syncs = new Vector();
        this.votes = new Vector();
        try {
            this.coord_skel = new CoordinatorPOATie(this);
            this.coord_ref = CoordinatorHelper.narrow(this.poa.servant_to_reference(this.coord_skel));
            this.term_skel = new TerminatorPOATie(this);
            this.term_ref = TerminatorHelper.narrow(this.poa.servant_to_reference(this.term_skel));
            this.contr_skel = new ControlPOATie(this);
            this.contr_ref = ControlHelper.narrow(this.poa.servant_to_reference(this.contr_skel));
        }
        catch (ServantNotActive servantNotActive) {
            throw new INTERNAL();
        }
        catch (WrongPolicy wrongPolicy) {
            throw new INTERNAL();
        }
        this.status = 0;
        if (n3 != 0) {
            TransactionService.get_timer().add_channel(this, n3);
        }
    }

    Control _get_control() {
        return this.contr_ref;
    }

    int _get_transaction_id() {
        return this.transaction_id;
    }

    public void commit(boolean bl) throws HeuristicMixed, HeuristicHazard {
        IDLEntity iDLEntity;
        IDLEntity iDLEntity2;
        if (!this.move_to_state(7)) {
            if (this.move_to_state(9)) {
                TransactionService.get_timer().kill_channel(this);
                this.rolling_to_back();
                throw new TRANSACTION_ROLLEDBACK();
            }
            throw new INTERNAL();
        }
        TransactionService.get_timer().kill_channel(this);
        int n = 0;
        while (n < this.syncs.size()) {
            iDLEntity2 = (Synchronization)this.syncs.elementAt(n);
            iDLEntity2.before_completion();
            ++n;
        }
        if (this.resources.size() == 1) {
            if (!this.move_to_state(2)) {
                throw new INTERNAL();
            }
            if (!this.move_to_state(8)) {
                throw new INTERNAL();
            }
            iDLEntity2 = (Resource)this.resources.elementAt(0);
            try {
                iDLEntity2.commit_one_phase();
            }
            catch (HeuristicHazard heuristicHazard) {
                throw new NO_IMPLEMENT();
            }
        }
        int n2 = 0;
        while (n2 < this.resources.size()) {
            Resource resource = (Resource)this.resources.elementAt(n2);
            try {
                iDLEntity = resource.prepare();
                this.votes.setElementAt(iDLEntity, n2);
                if (((Vote)iDLEntity).value() == 1) {
                    this.rollback();
                    throw new TRANSACTION_ROLLEDBACK();
                }
            }
            catch (HeuristicHazard heuristicHazard) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicMixed heuristicMixed) {
                throw new NO_IMPLEMENT();
            }
            ++n2;
        }
        if (!this.move_to_state(2)) {
            throw new INTERNAL();
        }
        if (!this.move_to_state(8)) {
            throw new INTERNAL();
        }
        int n3 = 0;
        while (n3 < this.resources.size()) {
            iDLEntity = (Resource)this.resources.elementAt(n3);
            Vote vote = (Vote)this.votes.elementAt(n3);
            try {
                if (vote == null) {
                    throw new INTERNAL();
                }
                if (vote.value() == 0) {
                    iDLEntity.commit();
                }
            }
            catch (NotPrepared notPrepared) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicRollback heuristicRollback) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicHazard heuristicHazard) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicMixed heuristicMixed) {
                throw new NO_IMPLEMENT();
            }
            ++n3;
        }
        if (!this.move_to_state(3)) {
            throw new INTERNAL();
        }
        this.forget();
        if (!this.move_to_state(6)) {
            throw new INTERNAL();
        }
        this.destroy();
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        throw new NO_IMPLEMENT();
    }

    private void destroy() {
        try {
            byte[] byArray = this.poa.reference_to_id(this.term_ref);
            this.poa.deactivate_object(byArray);
            this.term_ref._release();
            byArray = this.poa.reference_to_id(this.coord_ref);
            this.poa.deactivate_object(byArray);
            this.coord_ref._release();
            byArray = this.poa.reference_to_id(this.contr_ref);
            this.poa.deactivate_object(byArray);
            this.contr_ref._release();
        }
        catch (ObjectNotActive objectNotActive) {
            throw new INTERNAL();
        }
        catch (WrongPolicy wrongPolicy) {
            throw new INTERNAL();
        }
        catch (WrongAdapter wrongAdapter) {
            throw new INTERNAL();
        }
        TransactionService.release_coordinator(this.hash_code);
    }

    private void forget() {
        this.resources.removeAllElements();
        this.votes.removeAllElements();
        this.syncs.removeAllElements();
    }

    public Coordinator get_coordinator() throws Unavailable {
        if (this.status == 6) {
            throw new Unavailable();
        }
        return this.coord_ref;
    }

    public Status get_parent_status() {
        throw new NO_IMPLEMENT();
    }

    public Status get_status() {
        return Status.from_int(this.status);
    }

    public Terminator get_terminator() throws Unavailable {
        if (this.status == 6) {
            throw new Unavailable();
        }
        return this.term_ref;
    }

    public Status get_top_level_status() {
        return Status.from_int(this.status);
    }

    public String get_transaction_name() {
        return "Transaction_" + this.transaction_id;
    }

    public PropagationContext get_txcontext() throws Unavailable {
        throw new NO_IMPLEMENT();
    }

    public int hash_top_level_tran() {
        throw new NO_IMPLEMENT();
    }

    public int hash_transaction() {
        return this.hash_code;
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) {
        throw new NO_IMPLEMENT();
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        throw new NO_IMPLEMENT();
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        throw new NO_IMPLEMENT();
    }

    public boolean is_same_transaction(Coordinator coordinator) {
        return this.hash_code == coordinator.hash_transaction();
    }

    public boolean is_top_level_transaction() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean move_to_state(int n) {
        String string = this.stat_semaphore;
        synchronized (string) {
            switch (this.status) {
                case 0: {
                    switch (n) {
                        case 1: 
                        case 7: 
                        case 9: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
                case 1: {
                    switch (n) {
                        case 9: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
                case 2: {
                    switch (n) {
                        case 8: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
                case 3: {
                    switch (n) {
                        case 6: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
                case 4: {
                    switch (n) {
                        case 6: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
                case 5: {
                    throw new INTERNAL();
                }
                case 6: {
                    throw new INTERNAL();
                }
                case 7: {
                    switch (n) {
                        case 2: 
                        case 9: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
                case 8: {
                    switch (n) {
                        case 3: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
                case 9: {
                    switch (n) {
                        case 4: {
                            this.status = n;
                            return true;
                        }
                    }
                    return false;
                }
            }
            throw new INTERNAL();
        }
    }

    public RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        String string = this.stat_semaphore;
        synchronized (string) {
            if (this.status == 1) {
                throw new TRANSACTION_ROLLEDBACK();
            }
            if (this.status != 0) {
                throw new Inactive();
            }
            this.resources.addElement(resource);
            this.votes.addElement(null);
        }
        return null;
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws Inactive, NotSubtransaction {
        throw new NO_IMPLEMENT();
    }

    public void register_synchronization(Synchronization synchronization) throws Inactive, SynchronizationUnavailable {
        String string = this.stat_semaphore;
        synchronized (string) {
            if (this.status == 1) {
                throw new TRANSACTION_ROLLEDBACK();
            }
            if (this.status != 0) {
                throw new Inactive();
            }
            this.syncs.addElement(synchronization);
        }
    }

    public void rollback() {
        if (!this.move_to_state(9)) {
            throw new TRANSACTION_REQUIRED();
        }
        TransactionService.get_timer().kill_channel(this);
        this.rolling_to_back();
    }

    public void rollback_only() throws Inactive {
        if (!this.move_to_state(1)) {
            throw new Inactive();
        }
    }

    private void rolling_to_back() {
        int n = 0;
        while (n < this.resources.size()) {
            Resource resource = (Resource)this.resources.elementAt(n);
            Vote vote = (Vote)this.votes.elementAt(n);
            try {
                if (vote == null) {
                    resource.rollback();
                } else if (vote.value() == 0) {
                    resource.rollback();
                }
            }
            catch (HeuristicCommit heuristicCommit) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicMixed heuristicMixed) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicHazard heuristicHazard) {
                throw new NO_IMPLEMENT();
            }
            ++n;
        }
        if (!this.move_to_state(4)) {
            throw new INTERNAL();
        }
        this.forget();
        if (!this.move_to_state(6)) {
            throw new INTERNAL();
        }
        this.destroy();
    }

    public void wakeup() {
        TransactionService.get_timer().kill_channel(this);
        if (this.move_to_state(9)) {
            this.rolling_to_back();
        }
    }
}

