/*
 * Decompiled with CFR 0.152.
 */
package jacorb.util;

import jacorb.util.AssertionViolation;
import jacorb.util.Environment;
import java.io.PrintWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Debug {
    private static Environment e = new Environment();
    private static int _verbosity = Environment.verbosityLevel() & 0xFF;
    private static int _category = Environment.verbosityLevel() & 0xFFFFFF00;
    private static PrintWriter _log_file_out = Environment.logFileOut();
    private static Object synchronizer = new Object();
    public static final int QUIET = 0;
    public static final int IMPORTANT = 1;
    public static final int INFORMATION = 2;
    public static final int DEBUG1 = 3;
    public static final int ORB_CONNECT = 256;
    public static final int ORB_MISC = 512;
    public static final int POA = 1024;
    public static final int IMR = 2048;
    public static final int DSI = 4096;
    public static final int DII = 8192;
    public static final int INTERCEPTOR = 16384;
    public static final int DOMAIN = 32768;
    public static final int PROXY = 65536;
    public static final int COMPILER = 131072;
    public static final int TOOLS = 262144;
    public static final int NAMING = 0x1000000;
    public static final int TRADING = 0x2000000;
    public static final int EVENTS = 0x4000000;
    public static final int TRANSACTION = 0x8000000;
    public static final int SECURITY = 0x10000000;

    static {
        if (_category == 0) {
            _category = -256;
        }
    }

    public static void assert(int n, boolean bl, String string) {
        if (n > _verbosity) {
            return;
        }
        if (!bl) {
            throw new AssertionViolation(string);
        }
    }

    public static final void output(int n, String string) {
        int n2 = n & 0xFFFFFF00;
        int n3 = n & 0xFF;
        if (n2 == 0) {
            n2 = -256;
        }
        if ((n2 & _category) == 0) {
            return;
        }
        if (n3 > _verbosity) {
            return;
        }
        if (_log_file_out == null) {
            System.out.println("[ " + string + " ]");
        } else {
            _log_file_out.println("[ " + Environment.time() + "> " + string + " ]");
            _log_file_out.flush();
        }
    }

    public static void output(int n, String string, byte[] byArray) {
        Debug.output(n, string, byArray, 0, byArray.length);
    }

    public static synchronized void output(int n, String string, byte[] byArray, int n2) {
        Debug.output(n, string, byArray, 0, n2);
    }

    public static synchronized void output(int n, String string, byte[] byArray, int n2, int n3) {
        if (n > _verbosity) {
            return;
        }
        Object object = synchronizer;
        synchronized (object) {
            System.out.print("\nHexdump [" + string + "] len=" + n3 + "," + byArray.length);
            String string2 = "";
            int n4 = n2;
            while (n4 < n3) {
                if (n4 % 16 == 0) {
                    System.out.println(string2);
                    string2 = "";
                }
                string2 = String.valueOf(string2) + Debug.toAscii(byArray[n4]);
                System.out.print(Debug.toHex(byArray[n4]));
                if (n4 % 4 == 3) {
                    string2 = String.valueOf(string2) + " ";
                    System.out.print(" ");
                }
                ++n4;
            }
            System.out.println(string2);
        }
    }

    public static final void output(int n, Throwable throwable) {
        int n2 = n & 0xFFFFFF00;
        int n3 = n & 0xFF;
        if (n2 == 0) {
            n2 = -256;
        }
        if ((n2 & _category) == 0) {
            return;
        }
        if (n3 > _verbosity) {
            return;
        }
        if (_log_file_out == null || n == 0) {
            System.out.println("############################ StackTrace ############################");
            throwable.printStackTrace(System.out);
            System.out.println("####################################################################");
        }
        if (_log_file_out != null) {
            _log_file_out.println("############################ StackTrace ############################");
            throwable.printStackTrace(_log_file_out);
            _log_file_out.println("####################################################################");
            _log_file_out.flush();
        }
    }

    public static void printTrace(int n) {
        if (n > _verbosity) {
            return;
        }
        try {
            throw new RuntimeException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static final char toAscii(byte by) {
        if (by > 31 && by < 127) {
            return (char)by;
        }
        return '.';
    }

    public static final String toHex(byte by) {
        int n = (by & 0xFF) / 16;
        int n2 = (by & 0xFF) % 16;
        char c = (char)(n > 9 ? 65 + (n - 10) : 48 + n);
        char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
        return "" + c + c2 + " ";
    }
}

