/* Logger.java
 *
 * created: Wed Aug 30 2000
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/Logger.java,v 1.1 2000/08/31 10:02:36 kmr Exp $
 */

package diana;

/**
 *  An interface for simple logging of warnings/errors/messages.
 *
 *  @author Kim Rutherford <kmr@sanger.ac.uk>
 *  @version $Id: Logger.java,v 1.1 2000/08/31 10:02:36 kmr Exp $
 **/

import java.io.*;

public interface Logger {
  /**
   *  Send the given String to the log.
   **/
  public void log (final String message);

  /**
   *  Read from the given Reader and send it to the log.
   **/
  public void log (final Reader reader)
      throws IOException;
}
