/* ActMain.java
 *
 * created: Wed May 10 2000
 *
 * This file is part of Artemis
 *
 * Copyright (C) 2000  Genome Research Limited
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/ActMain.java,v 1.6 2000/09/18 12:37:42 kmr Exp $
 */

package diana.components;

import Dad;

import diana.*;
import diana.components.*;
import diana.sequence.*;

import uk.ac.sanger.pathogens.*;
import uk.ac.sanger.pathogens.embl.DocumentEntryFactory;
import uk.ac.sanger.pathogens.embl.ReadFormatException;
import uk.ac.sanger.pathogens.embl.EntryInformation;
import uk.ac.sanger.pathogens.embl.EntryInformationException;
import uk.ac.sanger.pathogens.embl.SimpleEntryInformation;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 *  The main window for the Artemis Comparison Tool.
 *
 *  @author Kim Rutherford <kmr@sanger.ac.uk>
 *  @version $Id: ActMain.java,v 1.6 2000/09/18 12:37:42 kmr Exp $
 **/

public class ActMain extends Splash {
  /**
   *  The constructor creates all the components for the main ACT window
   *  and sets up all the menu callbacks.
   **/
  public ActMain () {
    super ("Artemis Comparison Tool", Dad.version);
  }

  /**
   *  Make a new Comparator component from the given files.
   *  @param frame The Frame used when making a new MessageDialog.
   *  @param progress_listener The object to which InputStreamProgressEvents
   *    will be send while reading.
   *  @param subject_sequence_file_name
   *  @param query_sequence_file_name
   *  @param comparison_data_file_name
   
   **/
  public static void makeComparator (final Frame frame,
                                     final InputStreamProgressListener
                                       progress_listener,
                                     final String subject_sequence_file_name,
                                     final String query_sequence_file_name,
                                     final String comparison_data_file_name)
      throws IOException, OutOfRangeException, EntryInformationException {

    final EntryInformation subject_entry_information =
      new SimpleEntryInformation (Options.getArtemisEntryInformation ());

    
    final uk.ac.sanger.pathogens.embl.Entry subject_embl_entry =
      EntryFileDialog.getEntryFromFile (frame, 
                                        new File (subject_sequence_file_name),
                                        subject_entry_information,
                                        progress_listener);
    final Bases subject_embl_bases =
      new Bases (subject_embl_entry.getSequence ());

    final EntryGroup subject_entry_group =
      new SimpleEntryGroup (subject_embl_bases);

    final Entry subject_entry =
      new Entry (subject_entry_group.getBases (), subject_embl_entry);

    subject_entry_group.add (subject_entry);

    
    final EntryInformation query_entry_information =
      new SimpleEntryInformation (Options.getArtemisEntryInformation ());

    final uk.ac.sanger.pathogens.embl.Entry query_embl_entry =
      EntryFileDialog.getEntryFromFile (frame, 
                                        new File (query_sequence_file_name),
                                        query_entry_information,
                                        progress_listener);
    final Bases query_embl_bases =
      new Bases (query_embl_entry.getSequence ());

    final EntryGroup query_entry_group =
      new SimpleEntryGroup (query_embl_bases);

    final Entry query_entry =
      new Entry (query_entry_group.getBases (), query_embl_entry);

    query_entry_group.add (query_entry);

    
    final Document comparison_data_document =
      new FileDocument (new File (comparison_data_file_name));

    ComparisonData comparison_data =
      ComparisonDataFactory.readComparisonData (comparison_data_document);

    final ComparisonData swapped_comparison_data =
      comparison_data.flipMatchesIfNeeded (subject_entry_group.getBases (),
                                           query_entry_group.getBases ());

    if (swapped_comparison_data != null) {
      comparison_data = swapped_comparison_data;
    }


    final Comparator comparator =
      new Comparator (subject_entry_group, query_entry_group, comparison_data);

    comparator.setVisible (true);

    if (swapped_comparison_data != null) {
      final MessageFrame message_frame =
        new MessageFrame ("note: hits have been flipped to match the " +
                          "sequences");

      message_frame.setVisible (true);
    }
  }

  /**
   *  Return a Logger for warnings/errors/messages.
   **/
  public static Logger getLogger () {
    return logger;
  }

  /**
   *  Make all the menus and menu items for the main window.  Also sets up
   *  suitable ActionListener objects for each item.
   */
  protected void makeAllMenus () {
    final Menu file_menu = new Menu ("File");

    getMenuBar ().add (file_menu);

    MenuItem open_item = new MenuItem ("Open ...");
    file_menu.add (open_item);

    ActionListener open_listener = new ActionListener () {
      public void actionPerformed (ActionEvent event) {
        makeOpenDialog ();
      }
    };

    open_item.addActionListener (open_listener);

    MenuItem quit_item = new MenuItem ("Quit");
    file_menu.add (quit_item);

    ActionListener quit_listener = new ActionListener () {
      public void actionPerformed (ActionEvent event) {
        exit ();
      }
    };

    quit_item.addActionListener (quit_listener);

  }

  /**
   *  Create a dialog that allow the user to the choose two files to compare
   *  and a file containing comparison data.
   **/
  private void makeOpenDialog () {
    new ComparatorDialog ().setVisible (true);
  }

  /**
   *  Exit from ACT.
   **/
  protected void exit () {
    System.exit (0);
  }

  /**
   *  The Logger that is returned by getLogger().
   **/
  private final static LogViewer logger = new LogViewer ();
}
