/* MessageFrame.java
 *
 * created: Mon Jan 18 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/MessageFrame.java,v 1.5 2000/01/24 17:04:20 kmr Exp $
 **/

package diana.components;

import java.awt.*;
import java.awt.event.*;

/**
 *  A popup Frame box that displays a message and has an OK Button.
 *
 *  @author Kim Rutherford
 *  @version $Id: MessageFrame.java,v 1.5 2000/01/24 17:04:20 kmr Exp $
 **/

public class MessageFrame extends Frame {
  /**
   *  Create a new MessageFrame component.
   *  @param message The message to display in the Dialog and it's title.
   **/
  public MessageFrame (final String message) {
    this (message, message);

    this.message = new Label (message);
  }

  /**
   *  Create a new MessageFrame component.
   *  @param title The title of the new dialog Frame.
   *  @param message The message to display in the Dialog.
   **/
  public MessageFrame (final String title,
                       final String message) {
    super (title);

    this.message = new Label (message);
    
    add (this.message, "North");

    final Panel panel = new Panel ();

    panel.add (ok_button);
    ok_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        MessageFrame.this.dispose ();
      }
    });

    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent event) {
        MessageFrame.this.dispose ();
      }
    });

    addKeyListener (new KeyAdapter () {
      public void keyTyped(final KeyEvent e) {
//    System.out.println ("key:" + e.getKeyChar () + "  " + e.getKeyCode ());
        MessageFrame.this.dispose ();
      }
    });
    
    add (panel, "South");
    pack ();
    
    final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation (new Point ((screen.width - getSize ().width) / 2,
                            (screen.height - getSize ().height) / 2));

    setVisible (true);
  }

  final private Button ok_button = new Button ("OK");

  /**
   *  This is the message displayed above the OK button.  It can be set with
   *  setMessage ().
   **/
  private Label message;
}


