/* YesNoDialog.java
 *
 * created: Sat Dec 12 1998
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/YesNoDialog.java,v 1.6 2000/01/24 17:04:21 kmr Exp $
 */

package diana.components;

import java.awt.*;
import java.awt.event.*;

/**
 *  A popup dialog box that displays a message and then waits for the to press
 *  yes or no.
 *
 *  @author Kim Rutherford
 *  @version $Id: YesNoDialog.java,v 1.6 2000/01/24 17:04:21 kmr Exp $
 **/

public class YesNoDialog extends Dialog {
  /**
   *  Create a new YesNoDialog component.  The constructor does not show ()
   *  the dialog, call getResult () to do that.
   *  @param parent The parent window.
   *  @param title The title of the new dialog Frame.
   *  @param message The message to display in the Dialog.
   **/
  public YesNoDialog (Frame parent, String title, String message) {
    super (parent, message, true);
    
    add (new Label (message), "North");

    final Panel panel = new Panel ();

    panel.add (yes_button);
    yes_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        button_result = true;
        setVisible (false);
        YesNoDialog.this.dispose ();
      }
    });

    panel.add (no_button);
    no_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        button_result = false;
        setVisible (false);
        YesNoDialog.this.dispose ();
      }
    });

    addKeyListener (new KeyAdapter () {
      public void keyTyped(final KeyEvent e) {
//    System.out.println ("key:" + e.getKeyChar () + "  " + e.getKeyCode ());
        if (e.getKeyChar () == '\n') {
          button_result = true;
          setVisible (false);
          YesNoDialog.this.dispose ();
        }
      }
    });

    add (panel, "South");
    pack ();
        
    final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation (new Point ((screen.width - getSize ().width) / 2,
                            (screen.height - getSize ().height) / 2));
  }

  /**
   *  Create a new YesNoDialog component.  The constructor does not show ()
   *  the dialog, call getResult () to do that.
   *  @param parent The parent window.
   *  @param message The message to display in the Dialog and to uise as the
   *    title string.
   **/
  public YesNoDialog (Frame parent, String message) {
    this (parent, message, message);
  }
  
  /**
   *  This method calls show () on this object, and then waits for the user to
   *  press the Yes button or the No button.
   *  @return true is the user pressed Yes, false otherwise.
   **/
  public boolean getResult () {
//    System.out.println ("make visible...");
    
    setVisible (true);
    
    return button_result;
  }

  final Button yes_button = new Button ("Yes");

  final Button no_button = new Button ("No");

  /**
   *  Set by the yes and no button action listeners and read by getResult ().
   **/
  boolean button_result;
}

