/* FileProgressDocument.java
 *
 * created: Thu Feb 25 1999
 *
 * This file is part of Artemis
 *
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/uk/ac/sanger/pathogens/FileProgressDocument.java,v 1.4 2000/06/09 15:06:31 kmr Exp $
 **/

package uk.ac.sanger.pathogens;

import java.io.*;

/**
 *  This is a FileDocument which has the getInputStream () method overridden
 *  to return a FileProgressInputStream object.
 *
 *  @author Kim Rutherford
 *  @version $Id: FileProgressDocument.java,v 1.4 2000/06/09 15:06:31 kmr Exp $
 **/

public class FileProgressDocument extends FileDocument {
  /**
   *  Create a new FileProgressDocument from a File.
   *  @param location This should be a file or directory name.
   *  @param listener InputStreamProgressEvent objects will be sent to this
   *    listener as progress on reading is made.
   **/
  public FileProgressDocument (final File location,
                               final InputStreamProgressListener listener) {
    super (location);

    this.listener = listener;
  }

  /**
   *  Create a new ProgressInputStream object from this Document.  The
   *  contents of the Document can be read from the InputStream.
   *  @exception IOException Thrown if the Document can't be read from
   *    (for example if it doesn't exist).
   **/
  public InputStream getInputStream ()
      throws IOException {
    final InputStream real_input_stream = super.getInputStream ();

    return new ProgressInputStream (real_input_stream, listener);
  }

  /**
   *  InputStreamProgressEvents are sent to this object.
   **/
  private final InputStreamProgressListener listener;
}
