/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BAKERY_APP_H
#define BAKERY_APP_H

using namespace std;

#include <gnome--.h>
#include "libgnome/gnome-util.h" //For ::gnome_pixmap_file().
#include <gtk--.h>
#include <libgnome/gnome-i18n.h>

#include <vector>
#include <list>
#include <map>

//Features:
//- Override methods to add/change menus/toolbars/statusbar.
//  - Default is basic File, Edit, Help menus and toolbar icons.
//- Configurable about box via set_about_information().

//TODO:
//- Command-line args - wrap popt?
//- Session Management - need Command-line args.
//- Online Help - ?

//Extra notes:
//- The App is the main window.

namespace Bakery
{

class App : public Gnome::App
{
public: 
  App(const string& appname, const string& title); //Don't forget to call init() too.
  virtual ~App();
	
  virtual void init(); //Sets it up and shows it.

  //'About Box' information:
  typedef std::vector<string> type_vecStrings;	
  static void set_about_information(const string& strVersion, const type_vecStrings& vecAuthors, const string& strCopyright, const string& strDescription);
  virtual string get_version() const;

  static void set_command_line_args(int argc, char **&argv); //Needed for session management.


  typedef std::map<GnomeUIInfoConfigurableTypes, Gtk::Widget*> type_mapMenuItemWidgets;
		
protected:
  virtual void init_menus(); //Override this to add more menu or different menus.
  virtual void init_menus_file(); //Call this from init_menus() to add the standard file menu.
  virtual void init_menus_edit(); //Call this from init_menus() to add the standard edit menu
  virtual void init_menus_help(); //Call this from init_menus() to add the standard help menu.	
  virtual void init_toolbars();
  
  virtual App* new_instance() = 0; //Must override in order to new() the derived document class.
	
  //Signal handlers:

  //Menus:
  virtual void on_menu_File_New();
  virtual void on_menu_File_Close();
  virtual void on_menu_File_Exit();

  //Edit menu handlers overriden in App_WithDoc:
  virtual void on_menu_Edit_Cut();
  virtual void on_menu_Edit_Copy();
  virtual void on_menu_Edit_Paste();
  virtual void on_menu_Edit_Clear();
  
  virtual void on_menu_Help_About();


  virtual gint on_about_close();

  //GnomeClient Session Management:
  virtual void on_Session_die();
  virtual gint on_Session_save_yourself(gint phase, GnomeSaveStyle save_style, gint is_shutdown, GnomeInteractStyle interact_style, gint is_fast);

  virtual gint delete_event_impl(GdkEventAny *event); //override

  virtual void destroy_and_remove_from_list();
  virtual void remove_instance_from_list();

  //operation_cancelled:
  //e.g. A File|Open tries to save existing data,
  //but this needs to be cancelled if the save failed. 
  static void set_operation_cancelled(bool bVal = true);
  static bool get_operation_cancelled();

  //Member data:

  bool m_bInitialized; //Whether init() has been called.
  //'About Box'/WM Class information:
  std::string m_strAppName, m_strTitle;

  //'About Box' information:
  static std::string m_strVersion, m_strCopyright, m_strDescription;
  static type_vecStrings m_vecAuthors;

  //Instances:
  typedef std::list<App*> type_listAppInstances;
  static type_listAppInstances m_listAppInstances;
  static bool m_bExiting; //Tell the next instance to close too.
  static bool m_bOperationCancelled; //see set/get_operation_cancelled().

  //Menus, toolbars:
  typedef std::vector<Gnome::UI::SubTree> type_vecGnome_UI_SubTree;
  type_vecGnome_UI_SubTree m_menu_UI_Infos; //Filled by init_menus;
  typedef std::vector<Gnome::UI::Info> type_vecGnome_UI_Info;
  type_vecGnome_UI_Info m_toolbar_UI_Infos; //Filled by init_toolbars;

  //Member widgets:
  Gnome::AppBar m_Status;

  //All instances share 1 About box:
  static Gnome::About* m_pAbout; //About box.
  static bool m_bAboutShown;

  //Command line args:
  static std::string m_strCommandLine_0;
  
  //typedef std::vector<poptOption> type_vecPoptOptions;
  //type_vecPoptOptions m_vecPoptOptions;
};

} //namespace

#endif //BAKERY_APP_H
