/*************************************************
* Base64 Encoder/Decoder Header File             *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_BASE64_H__
#define BOTAN_BASE64_H__

#include <botan/filter.h>

namespace Botan {

/*************************************************
* Base64 Encoder                                 *
*************************************************/
class Base64_Encoder : public Filter
   {
   public:
      static void encode(const byte[3], byte[4]);

      void write(const byte[], u32bit);
      void end_msg();
      Base64_Encoder(bool = false, u32bit = 72);
   private:
      void encode_and_send(const byte[], u32bit);
      void do_output(const byte[], u32bit);
      const bool LINEBREAKS;
      const u32bit LINELENGTH;
      SecureVector<byte> in_buffer, out_buffer;
      u32bit position, counter;
   };

/*************************************************
* Base64 Decoder                                 *
*************************************************/
class Base64_Decoder : public Filter
   {
   public:
      static void decode(const byte[4], byte[3]);
      static bool is_valid(byte in) { return (BASE64_TO_BIN[in] != 0x80); }

      void write(const byte[], u32bit);
      void end_msg();
      Base64_Decoder();
   private:
      void decode_and_send(const byte[], u32bit);
      static const byte BASE64_TO_BIN[256];
      SecureVector<byte> in_buffer, out_buffer;
      u32bit position;
   };

}

#endif
