/*************************************************
* ECB Mode Header File                           *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_ECB_H__
#define BOTAN_ECB_H__

#include <botan/modebase.h>

namespace Botan {

/*************************************************
* ECB Base Class                                 *
*************************************************/
class ECB : public BlockCipherMode
   {
   public:
      void write(const byte[], u32bit);
      void end_msg();
      ECB(const std::string&, const SymmetricKey&, const std::string&);
   private:
      bool valid_iv_size(u32bit) const;
      virtual void process_block(const byte[], byte[]) = 0;
   };

/*************************************************
* ECB Encryption                                 *
*************************************************/
class ECB_Encryption : public ECB
   {
   public:
      ECB_Encryption(const std::string&, const SymmetricKey&);
   private:
      void process_block(const byte[], byte[]);
   };

/*************************************************
* ECB Decryption                                 *
*************************************************/
class ECB_Decryption : public ECB
   {
   public:
      ECB_Decryption(const std::string&, const SymmetricKey&);
   private:
      void process_block(const byte[], byte[]);
   };

}

#endif
