/*************************************************
* EMSA2 Header File                              *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_EMSA2_H__
#define BOTAN_EMSA2_H__

#include <botan/pk_misc.h>

namespace Botan {

/*************************************************
* EMSA2                                          *
*************************************************/
class EMSA2 : public EMSA
   {
   public:
      EMSA2(const std::string&);
      ~EMSA2() { delete hash; }
   private:
      void update(const byte[], u32bit);
      SecureVector<byte> encoding_of(const SecureVector<byte>&, u32bit);
      SecureVector<byte> raw_data();
      SecureVector<byte> empty_hash;
      HashFunction* hash;
      byte hash_id;
   };

}

#endif
