/*************************************************
* Filters Header File                            *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_FILTERS_H__
#define BOTAN_FILTERS_H__

#include <botan/key_filt.h>
#include <botan/fork.h>
#include <botan/chain.h>
#include <botan/pk_filts.h>
#include <botan/hex.h>
#include <botan/base64.h>
#include <botan/pipe.h>

namespace Botan {

/*************************************************
* Stream Cipher Filter                           *
*************************************************/
class StreamCipher_Filter : public Keyed_Filter
   {
   public:
      void seek(u32bit position) { cipher->seek(position); }
      void reset_key(const SymmetricKey& key) { cipher->set_key(key); }
      void write(const byte[], u32bit);

      StreamCipher_Filter(const std::string&, const SymmetricKey&);
      ~StreamCipher_Filter() { delete cipher; }
   private:
      StreamCipher* cipher;
      SecureBuffer<byte, DEFAULT_BUFFERSIZE> buffer;
   };

/*************************************************
* Hash Filter                                    *
*************************************************/
class Hash_Filter : public Filter
   {
   public:
      void write(const byte input[], u32bit len) { hash->update(input, len); }
      void end_msg();

      Hash_Filter(const std::string&, u32bit = 0);
      ~Hash_Filter() { delete hash; }
   private:
      const u32bit OUTPUT_LENGTH;
      HashFunction* hash;
   };

/*************************************************
* MessageAuthenticationCode Filter               *
*************************************************/
class MAC_Filter : public Keyed_Filter
   {
   public:
      void reset_key(const SymmetricKey& key) { mac->set_key(key); }
      void write(const byte input[], u32bit len) { mac->update(input, len); }
      void end_msg();

      MAC_Filter(const std::string&, const SymmetricKey&, u32bit = 0);
      ~MAC_Filter() { delete mac; }
   private:
      const u32bit OUTPUT_LENGTH;
      MessageAuthenticationCode* mac;
   };

}

#endif
