/*************************************************
* KDF2 Header File                               *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_KDF2_H__
#define BOTAN_KDF2_H__

#include <botan/pk_misc.h>

namespace Botan {

/*************************************************
* KDF2                                           *
*************************************************/
class KDF2 : public KDF
   {
   public:
      KDF2(const std::string&, const std::string& = "");
      ~KDF2() { delete hash; }
   private:
      SymmetricKey derive(const byte[], u32bit, u32bit) const;
      const std::string P;
      HashFunction* hash;
   };

}

#endif
