/*************************************************
* PK Algorithm Lookup Header File                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_PK_LOOKUP_H__
#define BOTAN_PK_LOOKUP_H__

#include <botan/pubkey.h>

namespace Botan {

/*************************************************
* Get an EMSA/EME/KDF/MGF function               *
*************************************************/
MGF*  get_mgf(const std::string&);
KDF*  get_kdf(const std::string&);
EME*  get_eme(const std::string&);
EMSA* get_emsa(const std::string&);

/*************************************************
* Get an PK algorithm object                     *
*************************************************/
PK_Encryptor* get_pk_encryptor(const PK_Encrypting_Key&, const std::string&);
PK_Decryptor* get_pk_decryptor(const PK_Decrypting_Key&, const std::string&);
PK_Signer*    get_pk_signer(const PK_Signing_Key&, const std::string&);
PK_Verifier*  get_pk_verifier(const PK_Verifying_with_MR_Key&,
                              const std::string&);
PK_Verifier*  get_pk_verifier(const PK_Verifying_wo_MR_Key&,
                              const std::string&);

PK_Key_Agreement_Scheme* get_pk_kas(const PK_Key_Agreement_Key&,
                                    const std::string&);

}

#endif
