/*************************************************
* Miller-Rabin Tester Header File                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MILLER_RABIN_H__
#define BOTAN_MILLER_RABIN_H__

#include <botan/bigint.h>
#include <botan/reducer.h>

namespace Botan {

/*************************************************
* Miller-Rabin Primality Tester                  *
*************************************************/
class MillerRabin_Test
   {
   public:
      bool passes_test(const BigInt&);

      MillerRabin_Test(const BigInt&);
      ~MillerRabin_Test() { delete reducer; }
   private:
      BigInt n, r, n_minus_1;
      u32bit s;
      ModularReducer* reducer;
   };

}

#endif
