/*************************************************
* Pipe Header File                               *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_PIPE_H__
#define BOTAN_PIPE_H__

#include <botan/filter.h>
#include <cstdio>
#include <iosfwd>
#include <vector>

namespace Botan {

/*************************************************
* Pipe                                           *
*************************************************/
class Pipe
   {
   public:
      static const u32bit DEFAULT_MESSAGE = 0xFFFFFFFF;

      void write(const byte[], u32bit);
      void write(byte input) { write(&input, 1); }
      void write(const std::string&);

      u32bit read(byte[], u32bit, u32bit = DEFAULT_MESSAGE);
      u32bit read(byte&, u32bit = DEFAULT_MESSAGE);
      SecureVector<byte> read_all(u32bit = DEFAULT_MESSAGE);
      std::string read_all_as_string(u32bit = DEFAULT_MESSAGE);
      u32bit remaining(u32bit = DEFAULT_MESSAGE) const;

      u32bit peek(byte[], u32bit, u32bit = DEFAULT_MESSAGE);
      u32bit peek(byte&, u32bit = DEFAULT_MESSAGE);

      // DEPRECATED FUNCTIONS
      u32bit read(u32bit m, byte b[], u32bit l) { return read(b, l, m); }
      u32bit read(u32bit m, byte& b) { return read(b, m); }
      u32bit peek(u32bit m, byte b[], u32bit l) { return peek(b, l, m); }
      u32bit peek(u32bit m, byte& b) { return peek(b, m); }
      // END DEPRECATED FUNCTIONS

      u32bit default_msg() const { return default_read; }
      void set_default_msg(u32bit);
      u32bit message_count() const { return messages.size(); }

      void start_msg();
      void end_msg();

      void prepend(Filter*);
      void append(Filter*);
      void pop();
      void reset();

      Pipe(Filter* = 0, Filter* = 0, Filter* = 0, Filter* = 0);
      Pipe(Filter*[], u32bit);
      ~Pipe() { destroy(pipe); }
   private:
      Pipe(const Pipe&) {}
      void operator=(const Pipe&) {}
      void init();
      void destruct(Filter*);
      void find_endpoints(Filter*);
      void clear_endpoints(Filter*);
      class SecureQueue* get_message(const std::string&, u32bit) const;
      std::vector<class SecureQueue*> messages;
      Filter* pipe;
      bool locked;
      u32bit default_read;
   };

/*************************************************
* I/O Operators for Pipe                         *
*************************************************/
std::ostream& operator<<(std::ostream&, Pipe&);
std::istream& operator>>(std::istream&, Pipe&);

std::FILE* operator<<(std::FILE*, Pipe&);
std::FILE* operator>>(std::FILE*, Pipe&);

}

#if defined(BOTAN_EXT_PIPE_UNIXFD_IO)
  #include <botan/pipe_fd.h>
#endif

#endif
